package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.Processes;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top level grouping for attributes for processes.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-procmon</b>
 * <pre>
 * grouping procmon-processes-top {
 *   container processes {
 *     list process {
 *       key pid;
 *       config false;
 *       leaf pid {
 *         type leafref {
 *           path ../state/pid;
 *         }
 *       }
 *       container state {
 *         config false;
 *         uses procmon-process-attributes-state;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-procmonprocmon-processes-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface ProcmonProcessesTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("procmon-processes-top");

    @Override
    Class<? extends ProcmonProcessesTop> implementedInterface();
    
    /**
     * Return processes, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Parameters related to all monitored processes
     *     </code>
     * </pre>
     *
     * @return {@code Processes} processes, or {@code null} if it is not present.
     *
     */
    Processes getProcesses();

}

