package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingSelectorsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.Selector;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.SelectorKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container 
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * container selectors {
 *   list selector {
 *     key "facility severity";
 *     leaf facility {
 *       type leafref {
 *         path ../config/facility;
 *       }
 *     }
 *     leaf severity {
 *       type leafref {
 *         path ../config/severity;
 *       }
 *     }
 *     container config {
 *       uses logging-selectors-config;
 *     }
 *     container state {
 *       config false;
 *       uses logging-selectors-config;
 *       uses logging-selectors-state;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-system-logginglogging-selectors-topselectors</i>
 *
 * <p>To create instances of this class use {@link SelectorsBuilder}.
 * @see SelectorsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Selectors
    extends
    ChildOf<LoggingSelectorsTop>,
    Augmentable<Selectors>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("selectors");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.@NonNull Selectors obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getSelector());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.@NonNull Selectors thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getSelector(), other.getSelector())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.@NonNull Selectors obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Selectors");
        CodeHelpers.appendValue(helper, "selector", obj.getSelector());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return selector, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of selectors for log messages
     *     </code>
     * </pre>
     *
     * @return {@code Map<SelectorKey, Selector>} selector, or {@code null} if it is not present.
     *
     */
    @Nullable Map<SelectorKey, Selector> getSelector();
    
    /**
     * Return selector, or an empty list if it is not present.
     *
     * @return {@code Map<SelectorKey, Selector>} selector, or an empty list if it is not present.
     *
     */
    default @NonNull Map<SelectorKey, Selector> nonnullSelector() {
        return CodeHelpers.nonnull(getSelector());
    }

}

