package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingRemoteTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.RemoteServer;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.RemoteServerKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for the list of remote log servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * container remote-servers {
 *   list remote-server {
 *     key host;
 *     leaf host {
 *       type leafref {
 *         path ../config/host;
 *       }
 *     }
 *     container config {
 *       uses logging-remote-config;
 *     }
 *     container state {
 *       config false;
 *       uses logging-remote-config;
 *       uses logging-remote-state;
 *     }
 *     uses logging-selectors-top;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-system-logginglogging-remote-topremote-servers</i>
 *
 * <p>To create instances of this class use {@link RemoteServersBuilder}.
 * @see RemoteServersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface RemoteServers
    extends
    ChildOf<LoggingRemoteTop>,
    Augmentable<RemoteServers>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("remote-servers");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.RemoteServers> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.RemoteServers.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.@NonNull RemoteServers obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getRemoteServer());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.@NonNull RemoteServers thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.RemoteServers other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.RemoteServers.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getRemoteServer(), other.getRemoteServer())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.@NonNull RemoteServers obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RemoteServers");
        CodeHelpers.appendValue(helper, "remoteServer", obj.getRemoteServer());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return remoteServer, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of remote log servers
     *     </code>
     * </pre>
     *
     * @return {@code Map<RemoteServerKey, RemoteServer>} remoteServer, or {@code null} if it is not present.
     *
     */
    @Nullable Map<RemoteServerKey, RemoteServer> getRemoteServer();
    
    /**
     * Return remoteServer, or an empty list if it is not present.
     *
     * @return {@code Map<RemoteServerKey, RemoteServer>} remoteServer, or an empty list if it is not present.
     *
     */
    default @NonNull Map<RemoteServerKey, RemoteServer> nonnullRemoteServer() {
        return CodeHelpers.nonnull(getRemoteServer());
    }

}

