package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum Transport implements Enumeration {
    /**
     * Transmission Control Protocol (TCP).
     */
    TCP(0, "TCP"),
    
    /**
     * Transport Layer Security (TLS).
     */
    TLS(1, "TLS")
    ;

    private static final Map<String, Transport> NAME_MAP;
    private static final Map<Integer, Transport> VALUE_MAP;

    static {
        final Builder<String, Transport> nb = ImmutableMap.builder();
        final Builder<Integer, Transport> vb = ImmutableMap.builder();
        for (Transport enumItem : Transport.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private Transport(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding Transport item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<Transport> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding Transport item, or null if no such item exists
     */
    public static Transport forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
