package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines configuration and operational state data related to Syslog 
 * messages that a device may generate. These messages are historically obtained 
 * through the Syslog transport, however this module allows for obtaining them 
 * through an alternative transport, such as a Subscribe operation over an RPC. 
 * This module does not usurp traditional syslog servers, which may still be 
 * configured through the /yang/system/openconfig-system.yang model, rather it 
 * provies the Operator with an alternative method of consuming messages.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * module openconfig-messages {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/messages";
 *   prefix oc-messages;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-system-logging {
 *     prefix oc-log;
 *   }
 *   oc-ext:openconfig-version 0.0.1;
 *   revision 2018-08-13 {
 *   }
 *   identity DEBUG_SERVICE {
 *   }
 *   grouping messages-config {
 *     leaf severity {
 *       type oc-log:syslog-severity;
 *     }
 *   }
 *   grouping messages-state {
 *     container message {
 *       oc-ext:telemetry-atomic;
 *       config false;
 *       leaf msg {
 *         type string;
 *       }
 *       leaf priority {
 *         type uint8;
 *       }
 *       leaf app-name {
 *         type string;
 *       }
 *       leaf procid {
 *         type string;
 *       }
 *       leaf msgid {
 *         type string;
 *       }
 *     }
 *   }
 *   grouping debug-messages-config {
 *     leaf service {
 *       type identityref {
 *         base DEBUG_SERVICE;
 *       }
 *     }
 *     leaf enabled {
 *       type boolean;
 *       default false;
 *     }
 *   }
 *   grouping debug-messages-top {
 *     container debug-entries {
 *       list debug-service {
 *         key service;
 *         leaf service {
 *           type leafref {
 *             path ../config/service;
 *           }
 *         }
 *         container config {
 *           uses debug-messages-config;
 *         }
 *         container state {
 *           config false;
 *           uses debug-messages-config;
 *         }
 *       }
 *     }
 *   }
 *   grouping messages-top {
 *     container messages {
 *       container config {
 *         uses messages-config;
 *       }
 *       container state {
 *         config false;
 *         uses messages-config;
 *         uses messages-state;
 *       }
 *       uses debug-messages-top;
 *     }
 *   }
 *   uses messages-top;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigMessagesData
    extends
    DataRoot,
    MessagesTop
{





}

