package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Reference leafrefs to interface / subinterface
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-interfaces</b>
 * <pre>
 * grouping interface-ref-common {
 *   leaf interface {
 *     type leafref {
 *       path /oc-if:interfaces/oc-if:interface/oc-if:name;
 *     }
 *   }
 *   leaf subinterface {
 *     type leafref {
 *       path /oc-if:interfaces/oc-if:interface[oc-if:name=current()/../interface]/oc-if:subinterfaces/oc-if:subinterface/oc-if:index;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-interfacesinterface-ref-common</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface InterfaceRefCommon
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("interface-ref-common");

    @Override
    Class<? extends InterfaceRefCommon> implementedInterface();
    
    /**
     * Return interface, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to a base interface. If a reference to a subinterface is required,
     *         this leaf must be specified to indicate the base interface.
     *     </code>
     * </pre>
     *
     * @return {@code String} interface, or {@code null} if it is not present.
     *
     */
    String getInterface();
    
    /**
     * Return interface, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to a base interface. If a reference to a subinterface is required,
     *         this leaf must be specified to indicate the base interface.
     *     </code>
     * </pre>
     *
     * @return {@code String} interface, guaranteed to be non-null.
     * @throws NoSuchElementException if interface is not present
     *
     */
    default @NonNull String requireInterface() {
        return CodeHelpers.require(getInterface(), "interface");
    }
    
    /**
     * Return subinterface, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to a subinterface -- this requires the base interface to be specified
     *         using the interface leaf in this container. If only a reference to a base
     *         interface is requuired, this leaf should not be set.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} subinterface, or {@code null} if it is not present.
     *
     */
    Uint32 getSubinterface();
    
    /**
     * Return subinterface, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to a subinterface -- this requires the base interface to be specified
     *         using the interface leaf in this container. If only a reference to a base
     *         interface is requuired, this leaf should not be set.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} subinterface, guaranteed to be non-null.
     * @throws NoSuchElementException if subinterface is not present
     *
     */
    default @NonNull Uint32 requireSubinterface() {
        return CodeHelpers.require(getSubinterface(), "subinterface");
    }

}

