package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.Ethernet;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * State variables for Ethernet interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * container state {
 *   config false;
 *   uses ethernet-interface-config;
 *   uses ethernet-interface-state;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-if-ethernetethernet-topethernetstate</i>
 *
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<Ethernet>,
    Augmentable<State>,
    EthernetInterfaceConfig,
    EthernetInterfaceState
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAutoNegotiate());
        result = prime * result + Objects.hashCode(obj.getCounters());
        result = prime * result + Objects.hashCode(obj.getDuplexMode());
        result = prime * result + Objects.hashCode(obj.getEnableFlowControl());
        result = prime * result + Objects.hashCode(obj.getHwMacAddress());
        result = prime * result + Objects.hashCode(obj.getMacAddress());
        result = prime * result + Objects.hashCode(obj.getNegotiatedDuplexMode());
        result = prime * result + Objects.hashCode(obj.getNegotiatedPortSpeed());
        result = prime * result + Objects.hashCode(obj.getPortSpeed());
        result = prime * result + Objects.hashCode(obj.getStandaloneLinkTraining());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.State other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.State.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAutoNegotiate(), other.getAutoNegotiate())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEnableFlowControl(), other.getEnableFlowControl())) {
            return false;
        }
        if (!Objects.equals(thisObj.getNegotiatedPortSpeed(), other.getNegotiatedPortSpeed())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPortSpeed(), other.getPortSpeed())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStandaloneLinkTraining(), other.getStandaloneLinkTraining())) {
            return false;
        }
        if (!Objects.equals(thisObj.getHwMacAddress(), other.getHwMacAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMacAddress(), other.getMacAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCounters(), other.getCounters())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDuplexMode(), other.getDuplexMode())) {
            return false;
        }
        if (!Objects.equals(thisObj.getNegotiatedDuplexMode(), other.getNegotiatedDuplexMode())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.@NonNull State obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "autoNegotiate", obj.getAutoNegotiate());
        CodeHelpers.appendValue(helper, "counters", obj.getCounters());
        CodeHelpers.appendValue(helper, "duplexMode", obj.getDuplexMode());
        CodeHelpers.appendValue(helper, "enableFlowControl", obj.getEnableFlowControl());
        CodeHelpers.appendValue(helper, "hwMacAddress", obj.getHwMacAddress());
        CodeHelpers.appendValue(helper, "macAddress", obj.getMacAddress());
        CodeHelpers.appendValue(helper, "negotiatedDuplexMode", obj.getNegotiatedDuplexMode());
        CodeHelpers.appendValue(helper, "negotiatedPortSpeed", obj.getNegotiatedPortSpeed());
        CodeHelpers.appendValue(helper, "portSpeed", obj.getPortSpeed());
        CodeHelpers.appendValue(helper, "standaloneLinkTraining", obj.getStandaloneLinkTraining());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

