package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceStateCounters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link CountersBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     CountersBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new CountersBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of CountersBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see CountersBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class CountersBuilder implements Builder<Counters> {

    private Counter64 _in8021qFrames;
    private Counter64 _inBlockErrors;
    private Counter64 _inCarrierErrors;
    private Counter64 _inCrcErrors;
    private Counter64 _inFragmentFrames;
    private Counter64 _inInterruptedTx;
    private Counter64 _inJabberFrames;
    private Counter64 _inLateCollision;
    private Counter64 _inMacControlFrames;
    private Counter64 _inMacErrorsRx;
    private Counter64 _inMacPauseFrames;
    private Counter64 _inMaxsizeExceeded;
    private Counter64 _inOversizeFrames;
    private Counter64 _inSingleCollision;
    private Counter64 _inSymbolError;
    private Counter64 _inUndersizeFrames;
    private Counter64 _out8021qFrames;
    private Counter64 _outMacControlFrames;
    private Counter64 _outMacErrorsTx;
    private Counter64 _outMacPauseFrames;


    Map<Class<? extends Augmentation<Counters>>, Augmentation<Counters>> augmentation = Collections.emptyMap();

    public CountersBuilder() {
    }
    
    
    
    public CountersBuilder(EthernetInterfaceStateCounters arg) {
        this._inMacControlFrames = arg.getInMacControlFrames();
        this._inMacPauseFrames = arg.getInMacPauseFrames();
        this._inOversizeFrames = arg.getInOversizeFrames();
        this._inUndersizeFrames = arg.getInUndersizeFrames();
        this._inJabberFrames = arg.getInJabberFrames();
        this._inFragmentFrames = arg.getInFragmentFrames();
        this._in8021qFrames = arg.getIn8021qFrames();
        this._inCrcErrors = arg.getInCrcErrors();
        this._inBlockErrors = arg.getInBlockErrors();
        this._inCarrierErrors = arg.getInCarrierErrors();
        this._inInterruptedTx = arg.getInInterruptedTx();
        this._inLateCollision = arg.getInLateCollision();
        this._inMacErrorsRx = arg.getInMacErrorsRx();
        this._inSingleCollision = arg.getInSingleCollision();
        this._inSymbolError = arg.getInSymbolError();
        this._inMaxsizeExceeded = arg.getInMaxsizeExceeded();
        this._outMacControlFrames = arg.getOutMacControlFrames();
        this._outMacPauseFrames = arg.getOutMacPauseFrames();
        this._out8021qFrames = arg.getOut8021qFrames();
        this._outMacErrorsTx = arg.getOutMacErrorsTx();
    }

    public CountersBuilder(Counters base) {
        Map<Class<? extends Augmentation<Counters>>, Augmentation<Counters>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._in8021qFrames = base.getIn8021qFrames();
        this._inBlockErrors = base.getInBlockErrors();
        this._inCarrierErrors = base.getInCarrierErrors();
        this._inCrcErrors = base.getInCrcErrors();
        this._inFragmentFrames = base.getInFragmentFrames();
        this._inInterruptedTx = base.getInInterruptedTx();
        this._inJabberFrames = base.getInJabberFrames();
        this._inLateCollision = base.getInLateCollision();
        this._inMacControlFrames = base.getInMacControlFrames();
        this._inMacErrorsRx = base.getInMacErrorsRx();
        this._inMacPauseFrames = base.getInMacPauseFrames();
        this._inMaxsizeExceeded = base.getInMaxsizeExceeded();
        this._inOversizeFrames = base.getInOversizeFrames();
        this._inSingleCollision = base.getInSingleCollision();
        this._inSymbolError = base.getInSymbolError();
        this._inUndersizeFrames = base.getInUndersizeFrames();
        this._out8021qFrames = base.getOut8021qFrames();
        this._outMacControlFrames = base.getOutMacControlFrames();
        this._outMacErrorsTx = base.getOutMacErrorsTx();
        this._outMacPauseFrames = base.getOutMacPauseFrames();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>EthernetInterfaceStateCounters</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetInterfaceStateCounters) {
            this._inMacControlFrames = ((EthernetInterfaceStateCounters)arg).getInMacControlFrames();
            this._inMacPauseFrames = ((EthernetInterfaceStateCounters)arg).getInMacPauseFrames();
            this._inOversizeFrames = ((EthernetInterfaceStateCounters)arg).getInOversizeFrames();
            this._inUndersizeFrames = ((EthernetInterfaceStateCounters)arg).getInUndersizeFrames();
            this._inJabberFrames = ((EthernetInterfaceStateCounters)arg).getInJabberFrames();
            this._inFragmentFrames = ((EthernetInterfaceStateCounters)arg).getInFragmentFrames();
            this._in8021qFrames = ((EthernetInterfaceStateCounters)arg).getIn8021qFrames();
            this._inCrcErrors = ((EthernetInterfaceStateCounters)arg).getInCrcErrors();
            this._inBlockErrors = ((EthernetInterfaceStateCounters)arg).getInBlockErrors();
            this._inCarrierErrors = ((EthernetInterfaceStateCounters)arg).getInCarrierErrors();
            this._inInterruptedTx = ((EthernetInterfaceStateCounters)arg).getInInterruptedTx();
            this._inLateCollision = ((EthernetInterfaceStateCounters)arg).getInLateCollision();
            this._inMacErrorsRx = ((EthernetInterfaceStateCounters)arg).getInMacErrorsRx();
            this._inSingleCollision = ((EthernetInterfaceStateCounters)arg).getInSingleCollision();
            this._inSymbolError = ((EthernetInterfaceStateCounters)arg).getInSymbolError();
            this._inMaxsizeExceeded = ((EthernetInterfaceStateCounters)arg).getInMaxsizeExceeded();
            this._outMacControlFrames = ((EthernetInterfaceStateCounters)arg).getOutMacControlFrames();
            this._outMacPauseFrames = ((EthernetInterfaceStateCounters)arg).getOutMacPauseFrames();
            this._out8021qFrames = ((EthernetInterfaceStateCounters)arg).getOut8021qFrames();
            this._outMacErrorsTx = ((EthernetInterfaceStateCounters)arg).getOutMacErrorsTx();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EthernetInterfaceStateCounters]");
    }

    public Counter64 getIn8021qFrames() {
        return _in8021qFrames;
    }
    
    public Counter64 getInBlockErrors() {
        return _inBlockErrors;
    }
    
    public Counter64 getInCarrierErrors() {
        return _inCarrierErrors;
    }
    
    public Counter64 getInCrcErrors() {
        return _inCrcErrors;
    }
    
    public Counter64 getInFragmentFrames() {
        return _inFragmentFrames;
    }
    
    public Counter64 getInInterruptedTx() {
        return _inInterruptedTx;
    }
    
    public Counter64 getInJabberFrames() {
        return _inJabberFrames;
    }
    
    public Counter64 getInLateCollision() {
        return _inLateCollision;
    }
    
    public Counter64 getInMacControlFrames() {
        return _inMacControlFrames;
    }
    
    public Counter64 getInMacErrorsRx() {
        return _inMacErrorsRx;
    }
    
    public Counter64 getInMacPauseFrames() {
        return _inMacPauseFrames;
    }
    
    public Counter64 getInMaxsizeExceeded() {
        return _inMaxsizeExceeded;
    }
    
    public Counter64 getInOversizeFrames() {
        return _inOversizeFrames;
    }
    
    public Counter64 getInSingleCollision() {
        return _inSingleCollision;
    }
    
    public Counter64 getInSymbolError() {
        return _inSymbolError;
    }
    
    public Counter64 getInUndersizeFrames() {
        return _inUndersizeFrames;
    }
    
    public Counter64 getOut8021qFrames() {
        return _out8021qFrames;
    }
    
    public Counter64 getOutMacControlFrames() {
        return _outMacControlFrames;
    }
    
    public Counter64 getOutMacErrorsTx() {
        return _outMacErrorsTx;
    }
    
    public Counter64 getOutMacPauseFrames() {
        return _outMacPauseFrames;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Counters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public CountersBuilder setIn8021qFrames(final Counter64 value) {
        this._in8021qFrames = value;
        return this;
    }
    
    public CountersBuilder setInBlockErrors(final Counter64 value) {
        this._inBlockErrors = value;
        return this;
    }
    
    public CountersBuilder setInCarrierErrors(final Counter64 value) {
        this._inCarrierErrors = value;
        return this;
    }
    
    public CountersBuilder setInCrcErrors(final Counter64 value) {
        this._inCrcErrors = value;
        return this;
    }
    
    public CountersBuilder setInFragmentFrames(final Counter64 value) {
        this._inFragmentFrames = value;
        return this;
    }
    
    public CountersBuilder setInInterruptedTx(final Counter64 value) {
        this._inInterruptedTx = value;
        return this;
    }
    
    public CountersBuilder setInJabberFrames(final Counter64 value) {
        this._inJabberFrames = value;
        return this;
    }
    
    public CountersBuilder setInLateCollision(final Counter64 value) {
        this._inLateCollision = value;
        return this;
    }
    
    public CountersBuilder setInMacControlFrames(final Counter64 value) {
        this._inMacControlFrames = value;
        return this;
    }
    
    public CountersBuilder setInMacErrorsRx(final Counter64 value) {
        this._inMacErrorsRx = value;
        return this;
    }
    
    public CountersBuilder setInMacPauseFrames(final Counter64 value) {
        this._inMacPauseFrames = value;
        return this;
    }
    
    public CountersBuilder setInMaxsizeExceeded(final Counter64 value) {
        this._inMaxsizeExceeded = value;
        return this;
    }
    
    public CountersBuilder setInOversizeFrames(final Counter64 value) {
        this._inOversizeFrames = value;
        return this;
    }
    
    public CountersBuilder setInSingleCollision(final Counter64 value) {
        this._inSingleCollision = value;
        return this;
    }
    
    public CountersBuilder setInSymbolError(final Counter64 value) {
        this._inSymbolError = value;
        return this;
    }
    
    public CountersBuilder setInUndersizeFrames(final Counter64 value) {
        this._inUndersizeFrames = value;
        return this;
    }
    
    public CountersBuilder setOut8021qFrames(final Counter64 value) {
        this._out8021qFrames = value;
        return this;
    }
    
    public CountersBuilder setOutMacControlFrames(final Counter64 value) {
        this._outMacControlFrames = value;
        return this;
    }
    
    public CountersBuilder setOutMacErrorsTx(final Counter64 value) {
        this._outMacErrorsTx = value;
        return this;
    }
    
    public CountersBuilder setOutMacPauseFrames(final Counter64 value) {
        this._outMacPauseFrames = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CountersBuilder addAugmentation(Augmentation<Counters> augmentation) {
        Class<? extends Augmentation<Counters>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CountersBuilder removeAugmentation(Class<? extends Augmentation<Counters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Counters build() {
        return new CountersImpl(this);
    }

    private static final class CountersImpl
        extends AbstractAugmentable<Counters>
        implements Counters {
    
        private final Counter64 _in8021qFrames;
        private final Counter64 _inBlockErrors;
        private final Counter64 _inCarrierErrors;
        private final Counter64 _inCrcErrors;
        private final Counter64 _inFragmentFrames;
        private final Counter64 _inInterruptedTx;
        private final Counter64 _inJabberFrames;
        private final Counter64 _inLateCollision;
        private final Counter64 _inMacControlFrames;
        private final Counter64 _inMacErrorsRx;
        private final Counter64 _inMacPauseFrames;
        private final Counter64 _inMaxsizeExceeded;
        private final Counter64 _inOversizeFrames;
        private final Counter64 _inSingleCollision;
        private final Counter64 _inSymbolError;
        private final Counter64 _inUndersizeFrames;
        private final Counter64 _out8021qFrames;
        private final Counter64 _outMacControlFrames;
        private final Counter64 _outMacErrorsTx;
        private final Counter64 _outMacPauseFrames;
    
        CountersImpl(CountersBuilder base) {
            super(base.augmentation);
            this._in8021qFrames = base.getIn8021qFrames();
            this._inBlockErrors = base.getInBlockErrors();
            this._inCarrierErrors = base.getInCarrierErrors();
            this._inCrcErrors = base.getInCrcErrors();
            this._inFragmentFrames = base.getInFragmentFrames();
            this._inInterruptedTx = base.getInInterruptedTx();
            this._inJabberFrames = base.getInJabberFrames();
            this._inLateCollision = base.getInLateCollision();
            this._inMacControlFrames = base.getInMacControlFrames();
            this._inMacErrorsRx = base.getInMacErrorsRx();
            this._inMacPauseFrames = base.getInMacPauseFrames();
            this._inMaxsizeExceeded = base.getInMaxsizeExceeded();
            this._inOversizeFrames = base.getInOversizeFrames();
            this._inSingleCollision = base.getInSingleCollision();
            this._inSymbolError = base.getInSymbolError();
            this._inUndersizeFrames = base.getInUndersizeFrames();
            this._out8021qFrames = base.getOut8021qFrames();
            this._outMacControlFrames = base.getOutMacControlFrames();
            this._outMacErrorsTx = base.getOutMacErrorsTx();
            this._outMacPauseFrames = base.getOutMacPauseFrames();
        }
    
        @Override
        public Counter64 getIn8021qFrames() {
            return _in8021qFrames;
        }
        
        @Override
        public Counter64 getInBlockErrors() {
            return _inBlockErrors;
        }
        
        @Override
        public Counter64 getInCarrierErrors() {
            return _inCarrierErrors;
        }
        
        @Override
        public Counter64 getInCrcErrors() {
            return _inCrcErrors;
        }
        
        @Override
        public Counter64 getInFragmentFrames() {
            return _inFragmentFrames;
        }
        
        @Override
        public Counter64 getInInterruptedTx() {
            return _inInterruptedTx;
        }
        
        @Override
        public Counter64 getInJabberFrames() {
            return _inJabberFrames;
        }
        
        @Override
        public Counter64 getInLateCollision() {
            return _inLateCollision;
        }
        
        @Override
        public Counter64 getInMacControlFrames() {
            return _inMacControlFrames;
        }
        
        @Override
        public Counter64 getInMacErrorsRx() {
            return _inMacErrorsRx;
        }
        
        @Override
        public Counter64 getInMacPauseFrames() {
            return _inMacPauseFrames;
        }
        
        @Override
        public Counter64 getInMaxsizeExceeded() {
            return _inMaxsizeExceeded;
        }
        
        @Override
        public Counter64 getInOversizeFrames() {
            return _inOversizeFrames;
        }
        
        @Override
        public Counter64 getInSingleCollision() {
            return _inSingleCollision;
        }
        
        @Override
        public Counter64 getInSymbolError() {
            return _inSymbolError;
        }
        
        @Override
        public Counter64 getInUndersizeFrames() {
            return _inUndersizeFrames;
        }
        
        @Override
        public Counter64 getOut8021qFrames() {
            return _out8021qFrames;
        }
        
        @Override
        public Counter64 getOutMacControlFrames() {
            return _outMacControlFrames;
        }
        
        @Override
        public Counter64 getOutMacErrorsTx() {
            return _outMacErrorsTx;
        }
        
        @Override
        public Counter64 getOutMacPauseFrames() {
            return _outMacPauseFrames;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Counters.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Counters.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Counters.bindingToString(this);
        }
    }
}
