package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Adds configuration items for Ethernet interfaces belonging to a logical 
 * aggregate / LAG
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-aggregate</b>
 * <pre>
 * grouping ethernet-if-aggregation-config {
 *   leaf aggregate-id {
 *     type leafref {
 *       path /oc-if:interfaces/oc-if:interface/oc-if:name;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-if-aggregateethernet-if-aggregation-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface EthernetIfAggregationConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-if-aggregation-config");

    @Override
    Class<? extends EthernetIfAggregationConfig> implementedInterface();
    
    /**
     * Return aggregateId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Specify the logical aggregate interface to which this interface belongs
     *     </code>
     * </pre>
     *
     * @return {@code String} aggregateId, or {@code null} if it is not present.
     *
     */
    String getAggregateId();
    
    /**
     * Return aggregateId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Specify the logical aggregate interface to which this interface belongs
     *     </code>
     * </pre>
     *
     * @return {@code String} aggregateId, guaranteed to be non-null.
     * @throws NoSuchElementException if aggregateId is not present
     *
     */
    default @NonNull String requireAggregateId() {
        return CodeHelpers.require(getAggregateId(), "aggregateid");
    }

}

