package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.Aggregation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level data definitions for LAGs
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-aggregate</b>
 * <pre>
 * grouping aggregation-logical-top {
 *   container aggregation {
 *     container config {
 *       uses aggregation-logical-config;
 *     }
 *     container state {
 *       config false;
 *       uses aggregation-logical-config;
 *       uses aggregation-logical-state;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-if-aggregateaggregation-logical-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AggregationLogicalTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aggregation-logical-top");

    @Override
    Class<? extends AggregationLogicalTop> implementedInterface();
    
    /**
     * Return aggregation, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Options for logical interfaces representing aggregates
     *     </code>
     * </pre>
     *
     * @return {@code Aggregation} aggregation, or {@code null} if it is not present.
     *
     */
    Aggregation getAggregation();

}

