package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

@Generated("mdsal-binding-generator")
public interface State1
    extends
    Augmentation<State>
{




    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.State1> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.State1.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.@NonNull State1 obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getEquipmentFailure());
        result = prime * result + Objects.hashCode(obj.getEquipmentMismatch());
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.@NonNull State1 thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.State1 other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.State1.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getEquipmentFailure(), other.getEquipmentFailure())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEquipmentMismatch(), other.getEquipmentMismatch())) {
            return false;
        }
        return true;
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.@NonNull State1 obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("State1");
        CodeHelpers.appendValue(helper, "equipmentFailure", obj.getEquipmentFailure());
        CodeHelpers.appendValue(helper, "equipmentMismatch", obj.getEquipmentMismatch());
        return helper.toString();
    }
    
    /**
     * Return equipmentFailure, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         If true, the hardware indicates that the component's physical equipment has
     *         failed
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} equipmentFailure, or {@code null} if it is not present.
     *
     */
    Boolean getEquipmentFailure();
    
    /**
     * Return equipmentFailure, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         If true, the hardware indicates that the component's physical equipment has
     *         failed
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} equipmentFailure, guaranteed to be non-null.
     * @throws NoSuchElementException if equipmentFailure is not present
     *
     */
    default @NonNull Boolean requireEquipmentFailure() {
        return CodeHelpers.require(getEquipmentFailure(), "equipmentfailure");
    }
    
    /**
     * Return equipmentMismatch, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         If true, the hardware indicates that the component inserted into the affected
     *         component's physical location is of a different type than what is configured
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} equipmentMismatch, or {@code null} if it is not present.
     *
     */
    Boolean getEquipmentMismatch();
    
    /**
     * Return equipmentMismatch, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         If true, the hardware indicates that the component inserted into the affected
     *         component's physical location is of a different type than what is configured
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} equipmentMismatch, guaranteed to be non-null.
     * @throws NoSuchElementException if equipmentMismatch is not present
     *
     */
    default @NonNull Boolean requireEquipmentMismatch() {
        return CodeHelpers.require(getEquipmentMismatch(), "equipmentmismatch");
    }

}

