package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAccountingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthorizationTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServergroupCommonTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.accounting.top.Accounting;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.top.Authentication;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.top.Authorization;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.ServerGroups;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.aaa.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.aaa.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AaaBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AaaBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new AaaBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AaaBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AaaBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class AaaBuilder implements Builder<Aaa> {

    private Accounting _accounting;
    private Authentication _authentication;
    private Authorization _authorization;
    private Config _config;
    private ServerGroups _serverGroups;
    private State _state;


    Map<Class<? extends Augmentation<Aaa>>, Augmentation<Aaa>> augmentation = Collections.emptyMap();

    public AaaBuilder() {
    }
    
    
    
    public AaaBuilder(AaaAuthenticationTop arg) {
        this._authentication = arg.getAuthentication();
    }
    
    public AaaBuilder(AaaAuthorizationTop arg) {
        this._authorization = arg.getAuthorization();
    }
    
    public AaaBuilder(AaaAccountingTop arg) {
        this._accounting = arg.getAccounting();
    }
    
    public AaaBuilder(AaaServergroupCommonTop arg) {
        this._serverGroups = arg.getServerGroups();
    }

    public AaaBuilder(Aaa base) {
        Map<Class<? extends Augmentation<Aaa>>, Augmentation<Aaa>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._accounting = base.getAccounting();
        this._authentication = base.getAuthentication();
        this._authorization = base.getAuthorization();
        this._config = base.getConfig();
        this._serverGroups = base.getServerGroups();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>AaaServergroupCommonTop</li>
     * <li>AaaAccountingTop</li>
     * <li>AaaAuthorizationTop</li>
     * <li>AaaAuthenticationTop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaServergroupCommonTop) {
            this._serverGroups = ((AaaServergroupCommonTop)arg).getServerGroups();
            isValidArg = true;
        }
        if (arg instanceof AaaAccountingTop) {
            this._accounting = ((AaaAccountingTop)arg).getAccounting();
            isValidArg = true;
        }
        if (arg instanceof AaaAuthorizationTop) {
            this._authorization = ((AaaAuthorizationTop)arg).getAuthorization();
            isValidArg = true;
        }
        if (arg instanceof AaaAuthenticationTop) {
            this._authentication = ((AaaAuthenticationTop)arg).getAuthentication();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaServergroupCommonTop, AaaAccountingTop, AaaAuthorizationTop, AaaAuthenticationTop]");
    }

    public Accounting getAccounting() {
        return _accounting;
    }
    
    public Authentication getAuthentication() {
        return _authentication;
    }
    
    public Authorization getAuthorization() {
        return _authorization;
    }
    
    public Config getConfig() {
        return _config;
    }
    
    public ServerGroups getServerGroups() {
        return _serverGroups;
    }
    
    public State getState() {
        return _state;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Aaa>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public AaaBuilder setAccounting(final Accounting value) {
        this._accounting = value;
        return this;
    }
    
    public AaaBuilder setAuthentication(final Authentication value) {
        this._authentication = value;
        return this;
    }
    
    public AaaBuilder setAuthorization(final Authorization value) {
        this._authorization = value;
        return this;
    }
    
    public AaaBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public AaaBuilder setServerGroups(final ServerGroups value) {
        this._serverGroups = value;
        return this;
    }
    
    public AaaBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AaaBuilder addAugmentation(Augmentation<Aaa> augmentation) {
        Class<? extends Augmentation<Aaa>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AaaBuilder removeAugmentation(Class<? extends Augmentation<Aaa>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Aaa build() {
        return new AaaImpl(this);
    }

    private static final class AaaImpl
        extends AbstractAugmentable<Aaa>
        implements Aaa {
    
        private final Accounting _accounting;
        private final Authentication _authentication;
        private final Authorization _authorization;
        private final Config _config;
        private final ServerGroups _serverGroups;
        private final State _state;
    
        AaaImpl(AaaBuilder base) {
            super(base.augmentation);
            this._accounting = base.getAccounting();
            this._authentication = base.getAuthentication();
            this._authorization = base.getAuthorization();
            this._config = base.getConfig();
            this._serverGroups = base.getServerGroups();
            this._state = base.getState();
        }
    
        @Override
        public Accounting getAccounting() {
            return _accounting;
        }
        
        @Override
        public Authentication getAuthentication() {
            return _authentication;
        }
        
        @Override
        public Authorization getAuthorization() {
            return _authorization;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public ServerGroups getServerGroups() {
            return _serverGroups;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Aaa.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Aaa.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Aaa.bindingToString(this);
        }
    }
}
