package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.Server;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data 
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * container state {
 *   config false;
 *   uses aaa-server-config;
 *   uses aaa-server-state;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-server-topserversserverstate</i>
 *
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<Server>,
    Augmentable<State>,
    AaaServerConfig,
    AaaServerState
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getConnectionAborts());
        result = prime * result + Objects.hashCode(obj.getConnectionCloses());
        result = prime * result + Objects.hashCode(obj.getConnectionFailures());
        result = prime * result + Objects.hashCode(obj.getConnectionOpens());
        result = prime * result + Objects.hashCode(obj.getConnectionTimeouts());
        result = prime * result + Objects.hashCode(obj.getErrorsReceived());
        result = prime * result + Objects.hashCode(obj.getMessagesReceived());
        result = prime * result + Objects.hashCode(obj.getMessagesSent());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getTimeout());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.State other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.State.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnectionAborts(), other.getConnectionAborts())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnectionCloses(), other.getConnectionCloses())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnectionFailures(), other.getConnectionFailures())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnectionOpens(), other.getConnectionOpens())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnectionTimeouts(), other.getConnectionTimeouts())) {
            return false;
        }
        if (!Objects.equals(thisObj.getErrorsReceived(), other.getErrorsReceived())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMessagesReceived(), other.getMessagesReceived())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMessagesSent(), other.getMessagesSent())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimeout(), other.getTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddress(), other.getAddress())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.@NonNull State obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "connectionAborts", obj.getConnectionAborts());
        CodeHelpers.appendValue(helper, "connectionCloses", obj.getConnectionCloses());
        CodeHelpers.appendValue(helper, "connectionFailures", obj.getConnectionFailures());
        CodeHelpers.appendValue(helper, "connectionOpens", obj.getConnectionOpens());
        CodeHelpers.appendValue(helper, "connectionTimeouts", obj.getConnectionTimeouts());
        CodeHelpers.appendValue(helper, "errorsReceived", obj.getErrorsReceived());
        CodeHelpers.appendValue(helper, "messagesReceived", obj.getMessagesReceived());
        CodeHelpers.appendValue(helper, "messagesSent", obj.getMessagesSent());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "timeout", obj.getTimeout());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

