package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.radius;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.RoutingPassword;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link ConfigBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ConfigBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ConfigBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ConfigBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ConfigBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ConfigBuilder implements Builder<Config> {

    private PortNumber _acctPort;
    private PortNumber _authPort;
    private Uint8 _retransmitAttempts;
    private RoutingPassword _secretKey;
    private CryptPasswordType _secretKeyHashed;
    private IpAddress _sourceAddress;


    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }
    
    
    
    public ConfigBuilder(AaaRadiusServerConfig arg) {
        this._authPort = arg.getAuthPort();
        this._acctPort = arg.getAcctPort();
        this._secretKey = arg.getSecretKey();
        this._secretKeyHashed = arg.getSecretKeyHashed();
        this._sourceAddress = arg.getSourceAddress();
        this._retransmitAttempts = arg.getRetransmitAttempts();
    }

    public ConfigBuilder(Config base) {
        Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._acctPort = base.getAcctPort();
        this._authPort = base.getAuthPort();
        this._retransmitAttempts = base.getRetransmitAttempts();
        this._secretKey = base.getSecretKey();
        this._secretKeyHashed = base.getSecretKeyHashed();
        this._sourceAddress = base.getSourceAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>AaaRadiusServerConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaRadiusServerConfig) {
            this._authPort = ((AaaRadiusServerConfig)arg).getAuthPort();
            this._acctPort = ((AaaRadiusServerConfig)arg).getAcctPort();
            this._secretKey = ((AaaRadiusServerConfig)arg).getSecretKey();
            this._secretKeyHashed = ((AaaRadiusServerConfig)arg).getSecretKeyHashed();
            this._sourceAddress = ((AaaRadiusServerConfig)arg).getSourceAddress();
            this._retransmitAttempts = ((AaaRadiusServerConfig)arg).getRetransmitAttempts();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaRadiusServerConfig]");
    }

    public PortNumber getAcctPort() {
        return _acctPort;
    }
    
    public PortNumber getAuthPort() {
        return _authPort;
    }
    
    public Uint8 getRetransmitAttempts() {
        return _retransmitAttempts;
    }
    
    public RoutingPassword getSecretKey() {
        return _secretKey;
    }
    
    public CryptPasswordType getSecretKeyHashed() {
        return _secretKeyHashed;
    }
    
    public IpAddress getSourceAddress() {
        return _sourceAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ConfigBuilder setAcctPort(final PortNumber value) {
        this._acctPort = value;
        return this;
    }
    
    public ConfigBuilder setAuthPort(final PortNumber value) {
        this._authPort = value;
        return this;
    }
    
    public ConfigBuilder setRetransmitAttempts(final Uint8 value) {
        this._retransmitAttempts = value;
        return this;
    }
    
    public ConfigBuilder setSecretKey(final RoutingPassword value) {
        this._secretKey = value;
        return this;
    }
    
    public ConfigBuilder setSecretKeyHashed(final CryptPasswordType value) {
        this._secretKeyHashed = value;
        return this;
    }
    
    public ConfigBuilder setSourceAddress(final IpAddress value) {
        this._sourceAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class<? extends Augmentation<Config>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
        extends AbstractAugmentable<Config>
        implements Config {
    
        private final PortNumber _acctPort;
        private final PortNumber _authPort;
        private final Uint8 _retransmitAttempts;
        private final RoutingPassword _secretKey;
        private final CryptPasswordType _secretKeyHashed;
        private final IpAddress _sourceAddress;
    
        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._acctPort = base.getAcctPort();
            this._authPort = base.getAuthPort();
            this._retransmitAttempts = base.getRetransmitAttempts();
            this._secretKey = base.getSecretKey();
            this._secretKeyHashed = base.getSecretKeyHashed();
            this._sourceAddress = base.getSourceAddress();
        }
    
        @Override
        public PortNumber getAcctPort() {
            return _acctPort;
        }
        
        @Override
        public PortNumber getAuthPort() {
            return _authPort;
        }
        
        @Override
        public Uint8 getRetransmitAttempts() {
            return _retransmitAttempts;
        }
        
        @Override
        public RoutingPassword getSecretKey() {
            return _secretKey;
        }
        
        @Override
        public CryptPasswordType getSecretKeyHashed() {
            return _secretKeyHashed;
        }
        
        @Override
        public IpAddress getSourceAddress() {
            return _sourceAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config.bindingToString(this);
        }
    }
}
