package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link CountersBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     CountersBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new CountersBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of CountersBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see CountersBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class CountersBuilder implements Builder<Counters> {

    private Counter64 _accessAccepts;
    private Counter64 _accessRejects;
    private Counter64 _retriedAccessRequests;
    private Counter64 _timeoutAccessRequests;


    Map<Class<? extends Augmentation<Counters>>, Augmentation<Counters>> augmentation = Collections.emptyMap();

    public CountersBuilder() {
    }
    
    

    public CountersBuilder(Counters base) {
        Map<Class<? extends Augmentation<Counters>>, Augmentation<Counters>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._accessAccepts = base.getAccessAccepts();
        this._accessRejects = base.getAccessRejects();
        this._retriedAccessRequests = base.getRetriedAccessRequests();
        this._timeoutAccessRequests = base.getTimeoutAccessRequests();
    }


    public Counter64 getAccessAccepts() {
        return _accessAccepts;
    }
    
    public Counter64 getAccessRejects() {
        return _accessRejects;
    }
    
    public Counter64 getRetriedAccessRequests() {
        return _retriedAccessRequests;
    }
    
    public Counter64 getTimeoutAccessRequests() {
        return _timeoutAccessRequests;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Counters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public CountersBuilder setAccessAccepts(final Counter64 value) {
        this._accessAccepts = value;
        return this;
    }
    
    public CountersBuilder setAccessRejects(final Counter64 value) {
        this._accessRejects = value;
        return this;
    }
    
    public CountersBuilder setRetriedAccessRequests(final Counter64 value) {
        this._retriedAccessRequests = value;
        return this;
    }
    
    public CountersBuilder setTimeoutAccessRequests(final Counter64 value) {
        this._timeoutAccessRequests = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CountersBuilder addAugmentation(Augmentation<Counters> augmentation) {
        Class<? extends Augmentation<Counters>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CountersBuilder removeAugmentation(Class<? extends Augmentation<Counters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Counters build() {
        return new CountersImpl(this);
    }

    private static final class CountersImpl
        extends AbstractAugmentable<Counters>
        implements Counters {
    
        private final Counter64 _accessAccepts;
        private final Counter64 _accessRejects;
        private final Counter64 _retriedAccessRequests;
        private final Counter64 _timeoutAccessRequests;
    
        CountersImpl(CountersBuilder base) {
            super(base.augmentation);
            this._accessAccepts = base.getAccessAccepts();
            this._accessRejects = base.getAccessRejects();
            this._retriedAccessRequests = base.getRetriedAccessRequests();
            this._timeoutAccessRequests = base.getTimeoutAccessRequests();
        }
    
        @Override
        public Counter64 getAccessAccepts() {
            return _accessAccepts;
        }
        
        @Override
        public Counter64 getAccessRejects() {
            return _accessRejects;
        }
        
        @Override
        public Counter64 getRetriedAccessRequests() {
            return _retriedAccessRequests;
        }
        
        @Override
        public Counter64 getTimeoutAccessRequests() {
            return _timeoutAccessRequests;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Counters.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Counters.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Counters.bindingToString(this);
        }
    }
}
