package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A collection of RADIUS related state objects.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * container counters {
 *   leaf retried-access-requests {
 *     type oc-yang:counter64;
 *   }
 *   leaf access-accepts {
 *     type oc-yang:counter64;
 *   }
 *   leaf access-rejects {
 *     type oc-yang:counter64;
 *   }
 *   leaf timeout-access-requests {
 *     type oc-yang:counter64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-radius-server-statecounters</i>
 *
 * <p>To create instances of this class use {@link CountersBuilder}.
 * @see CountersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Counters
    extends
    ChildOf<AaaRadiusServerState>,
    Augmentable<Counters>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("counters");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.Counters> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.Counters.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.@NonNull Counters obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAccessAccepts());
        result = prime * result + Objects.hashCode(obj.getAccessRejects());
        result = prime * result + Objects.hashCode(obj.getRetriedAccessRequests());
        result = prime * result + Objects.hashCode(obj.getTimeoutAccessRequests());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.@NonNull Counters thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.Counters other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.Counters.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAccessAccepts(), other.getAccessAccepts())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAccessRejects(), other.getAccessRejects())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRetriedAccessRequests(), other.getRetriedAccessRequests())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimeoutAccessRequests(), other.getTimeoutAccessRequests())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.@NonNull Counters obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Counters");
        CodeHelpers.appendValue(helper, "accessAccepts", obj.getAccessAccepts());
        CodeHelpers.appendValue(helper, "accessRejects", obj.getAccessRejects());
        CodeHelpers.appendValue(helper, "retriedAccessRequests", obj.getRetriedAccessRequests());
        CodeHelpers.appendValue(helper, "timeoutAccessRequests", obj.getTimeoutAccessRequests());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return retriedAccessRequests, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Retransmitted Access-Request messages.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} retriedAccessRequests, or {@code null} if it is not present.
     *
     */
    Counter64 getRetriedAccessRequests();
    
    /**
     * Return retriedAccessRequests, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Retransmitted Access-Request messages.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} retriedAccessRequests, guaranteed to be non-null.
     * @throws NoSuchElementException if retriedAccessRequests is not present
     *
     */
    default @NonNull Counter64 requireRetriedAccessRequests() {
        return CodeHelpers.require(getRetriedAccessRequests(), "retriedaccessrequests");
    }
    
    /**
     * Return accessAccepts, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Received Access-Accept messages.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} accessAccepts, or {@code null} if it is not present.
     *
     */
    Counter64 getAccessAccepts();
    
    /**
     * Return accessAccepts, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Received Access-Accept messages.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} accessAccepts, guaranteed to be non-null.
     * @throws NoSuchElementException if accessAccepts is not present
     *
     */
    default @NonNull Counter64 requireAccessAccepts() {
        return CodeHelpers.require(getAccessAccepts(), "accessaccepts");
    }
    
    /**
     * Return accessRejects, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Received Access-Reject messages.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} accessRejects, or {@code null} if it is not present.
     *
     */
    Counter64 getAccessRejects();
    
    /**
     * Return accessRejects, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Received Access-Reject messages.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} accessRejects, guaranteed to be non-null.
     * @throws NoSuchElementException if accessRejects is not present
     *
     */
    default @NonNull Counter64 requireAccessRejects() {
        return CodeHelpers.require(getAccessRejects(), "accessrejects");
    }
    
    /**
     * Return timeoutAccessRequests, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Access-Request messages that have timed-out, requiring retransmission.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} timeoutAccessRequests, or {@code null} if it is not present.
     *
     */
    Counter64 getTimeoutAccessRequests();
    
    /**
     * Return timeoutAccessRequests, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Access-Request messages that have timed-out, requiring retransmission.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} timeoutAccessRequests, guaranteed to be non-null.
     * @throws NoSuchElementException if timeoutAccessRequests is not present
     *
     */
    default @NonNull Counter64 requireTimeoutAccessRequests() {
        return CodeHelpers.require(getTimeoutAccessRequests(), "timeoutaccessrequests");
    }

}

