package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthorizationEventsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.Event;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.EventKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for the set of events subject to authorization
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * container events {
 *   list event {
 *     key event-type;
 *     leaf event-type {
 *       type leafref {
 *         path ../config/event-type;
 *       }
 *     }
 *     container config {
 *       uses aaa-authorization-events-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-authorization-events-config;
 *       uses aaa-authorization-events-state;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-authorization-events-topevents</i>
 *
 * <p>To create instances of this class use {@link EventsBuilder}.
 * @see EventsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Events
    extends
    ChildOf<AaaAuthorizationEventsTop>,
    Augmentable<Events>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("events");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.Events> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.Events.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.@NonNull Events obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getEvent());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.@NonNull Events thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.Events other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.Events.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getEvent(), other.getEvent())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.@NonNull Events obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Events");
        CodeHelpers.appendValue(helper, "event", obj.getEvent());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return event, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of events subject to AAA authorization
     *     </code>
     * </pre>
     *
     * @return {@code Map<EventKey, Event>} event, or {@code null} if it is not present.
     *
     */
    @Nullable Map<EventKey, Event> getEvent();
    
    /**
     * Return event, or an empty list if it is not present.
     *
     * @return {@code Map<EventKey, Event>} event, or an empty list if it is not present.
     *
     */
    default @NonNull Map<EventKey, Event> nonnullEvent() {
        return CodeHelpers.nonnull(getEvent());
    }

}

