package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users.user.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users.user.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link UserBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UserBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new UserBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UserBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UserBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class UserBuilder implements Builder<User> {

    private Config _config;
    private State _state;
    private String _username;
    private UserKey key;


    Map<Class<? extends Augmentation<User>>, Augmentation<User>> augmentation = Collections.emptyMap();

    public UserBuilder() {
    }
    
    
    

    public UserBuilder(User base) {
        Map<Class<? extends Augmentation<User>>, Augmentation<User>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._username = base.getUsername();
        this._config = base.getConfig();
        this._state = base.getState();
    }


    public UserKey key() {
        return key;
    }
    
    public Config getConfig() {
        return _config;
    }
    
    public State getState() {
        return _state;
    }
    
    public String getUsername() {
        return _username;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<User>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public UserBuilder withKey(final UserKey key) {
        this.key = key;
        return this;
    }
    
    public UserBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public UserBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    public UserBuilder setUsername(final String value) {
        this._username = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UserBuilder addAugmentation(Augmentation<User> augmentation) {
        Class<? extends Augmentation<User>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UserBuilder removeAugmentation(Class<? extends Augmentation<User>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public User build() {
        return new UserImpl(this);
    }

    private static final class UserImpl
        extends AbstractAugmentable<User>
        implements User {
    
        private final Config _config;
        private final State _state;
        private final String _username;
        private final UserKey key;
    
        UserImpl(UserBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new UserKey(base.getUsername());
            }
            this._username = key.getUsername();
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public UserKey key() {
            return key;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public State getState() {
            return _state;
        }
        
        @Override
        public String getUsername() {
            return _username;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = User.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return User.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return User.bindingToString(this);
        }
    }
}
