package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAASERVERTYPE;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for AAA server groups
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-servergroup-common-config {
 *   leaf name {
 *     type string;
 *   }
 *   leaf type {
 *     type identityref {
 *       base AAA_SERVER_TYPE;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-servergroup-common-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaServergroupCommonConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-servergroup-common-config");

    @Override
    Class<? extends AaaServergroupCommonConfig> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name for the server group
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name for the server group
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return type, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         AAA server type -- all servers in the group must be of this type
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends AAASERVERTYPE>} type, or {@code null} if it is not present.
     *
     */
    Class<? extends AAASERVERTYPE> getType();
    
    /**
     * Return type, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         AAA server type -- all servers in the group must be of this type
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends AAASERVERTYPE>} type, guaranteed to be non-null.
     * @throws NoSuchElementException if type is not present
     *
     */
    default @NonNull Class<? extends AAASERVERTYPE> requireType() {
        return CodeHelpers.require(getType(), "type");
    }

}

