package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.Counters;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for a RADIUS server
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-radius-server-state {
 *   container counters {
 *     leaf retried-access-requests {
 *       type oc-yang:counter64;
 *     }
 *     leaf access-accepts {
 *       type oc-yang:counter64;
 *     }
 *     leaf access-rejects {
 *       type oc-yang:counter64;
 *     }
 *     leaf timeout-access-requests {
 *       type oc-yang:counter64;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-radius-server-state</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaRadiusServerState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-radius-server-state");

    @Override
    Class<? extends AaaRadiusServerState> implementedInterface();
    
    /**
     * Return counters, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A collection of RADIUS related state objects.
     *     </code>
     * </pre>
     *
     * @return {@code Counters} counters, or {@code null} if it is not present.
     *
     */
    Counters getCounters();

}

