package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.top.Authentication;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for top-level authentication
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-authentication-top {
 *   container authentication {
 *     container config {
 *       uses aaa-authentication-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-authentication-config;
 *       uses aaa-authentication-state;
 *     }
 *     uses aaa-authentication-admin-top;
 *     uses aaa-authentication-user-top;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-authentication-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAuthenticationTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-authentication-top");

    @Override
    Class<? extends AaaAuthenticationTop> implementedInterface();
    
    /**
     * Return authentication, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for global authentication data
     *     </code>
     * </pre>
     *
     * @return {@code Authentication} authentication, or {@code null} if it is not present.
     *
     */
    Authentication getAuthentication();

}

