package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.accounting.top.Accounting;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for user activity accounting
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-accounting-top {
 *   container accounting {
 *     container config {
 *       uses aaa-accounting-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-accounting-config;
 *       uses aaa-accounting-state;
 *     }
 *     uses aaa-accounting-events-top;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-accounting-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAccountingTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-accounting-top");

    @Override
    Class<? extends AaaAccountingTop> implementedInterface();
    
    /**
     * Return accounting, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for AAA accounting
     *     </code>
     * </pre>
     *
     * @return {@code Accounting} accounting, or {@code null} if it is not present.
     *
     */
    Accounting getAccounting();

}

