package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageremove.output;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.SonicOutput;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ImageRemoveResponse} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ImageRemoveResponse createImageRemoveResponse(int fooXyzzy, int barBaz) {
 *         return new ImageRemoveResponseBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ImageRemoveResponse, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ImageRemoveResponse
 *
 */
@Generated("mdsal-binding-generator")
public class ImageRemoveResponseBuilder {

    private SonicOutput _sonicOutput;


    Map<Class<? extends Augmentation<ImageRemoveResponse>>, Augmentation<ImageRemoveResponse>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ImageRemoveResponseBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveResponse}.
     *
     * @param arg org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveResponse from which the builder should be initialized
     */
    public ImageRemoveResponseBuilder(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveResponse arg) {
        this._sonicOutput = arg.getSonicOutput();
    }
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.SonicOutput}.
     *
     * @param arg org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.SonicOutput from which the builder should be initialized
     */
    public ImageRemoveResponseBuilder(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.SonicOutput arg) {
        this._sonicOutput = arg.getSonicOutput();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link ImageRemoveResponse}.
     *
     * @param base ImageRemoveResponse from which the builder should be initialized
     */
    public ImageRemoveResponseBuilder(ImageRemoveResponse base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._sonicOutput = base.getSonicOutput();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveResponse}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.SonicOutput}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveResponse castArg) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.SonicOutput castArg) {
            this._sonicOutput = castArg.getSonicOutput();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveResponse, org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.SonicOutput]");
    }

    private static final class LazyEmpty {
        static final @NonNull ImageRemoveResponse INSTANCE = new ImageRemoveResponseBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of ImageRemoveResponse.
     *
     * @return An empty {@link ImageRemoveResponse}
     */
    public static @NonNull ImageRemoveResponse empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link ImageRemoveResponse#getSonicOutput()}.
     *
     * @return current value
     */
    public SonicOutput getSonicOutput() {
        return _sonicOutput;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ImageRemoveResponse>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ImageRemoveResponse#getSonicOutput()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ImageRemoveResponseBuilder setSonicOutput(final SonicOutput value) {
        this._sonicOutput = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ImageRemoveResponseBuilder addAugmentation(Augmentation<ImageRemoveResponse> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ImageRemoveResponseBuilder removeAugmentation(Class<? extends Augmentation<ImageRemoveResponse>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ImageRemoveResponse} instance.
     *
     * @return A new {@link ImageRemoveResponse} instance.
     */
    public @NonNull ImageRemoveResponse build() {
        return new ImageRemoveResponseImpl(this);
    }

    private static final class ImageRemoveResponseImpl
        extends AbstractAugmentable<ImageRemoveResponse>
        implements ImageRemoveResponse {
    
        private final SonicOutput _sonicOutput;
    
        ImageRemoveResponseImpl(ImageRemoveResponseBuilder base) {
            super(base.augmentation);
            this._sonicOutput = base.getSonicOutput();
        }
    
        @Override
        public SonicOutput getSonicOutput() {
            return _sonicOutput;
        }
    
        @Override
        public SonicOutput nonnullSonicOutput() {
            return Objects.requireNonNullElse(getSonicOutput(), org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.SonicOutputBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ImageRemoveResponse.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ImageRemoveResponse.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ImageRemoveResponse.bindingToString(this);
        }
    }
}
