package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageremove.input;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ImageRemoveRequest} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ImageRemoveRequest createImageRemoveRequest(int fooXyzzy, int barBaz) {
 *         return new ImageRemoveRequestBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ImageRemoveRequest, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ImageRemoveRequest
 *
 */
@Generated("mdsal-binding-generator")
public class ImageRemoveRequestBuilder {

    private String _imagename;


    Map<Class<? extends Augmentation<ImageRemoveRequest>>, Augmentation<ImageRemoveRequest>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ImageRemoveRequestBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveRequest}.
     *
     * @param arg org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveRequest from which the builder should be initialized
     */
    public ImageRemoveRequestBuilder(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveRequest arg) {
        this._imagename = arg.getImagename();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link ImageRemoveRequest}.
     *
     * @param base ImageRemoveRequest from which the builder should be initialized
     */
    public ImageRemoveRequestBuilder(ImageRemoveRequest base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._imagename = base.getImagename();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveRequest}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveRequest castArg) {
            this._imagename = castArg.getImagename();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveRequest]");
    }

    private static final class LazyEmpty {
        static final @NonNull ImageRemoveRequest INSTANCE = new ImageRemoveRequestBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of ImageRemoveRequest.
     *
     * @return An empty {@link ImageRemoveRequest}
     */
    public static @NonNull ImageRemoveRequest empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link ImageRemoveRequest#getImagename()}.
     *
     * @return current value
     */
    public String getImagename() {
        return _imagename;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ImageRemoveRequest>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ImageRemoveRequest#getImagename()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ImageRemoveRequestBuilder setImagename(final String value) {
        this._imagename = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ImageRemoveRequestBuilder addAugmentation(Augmentation<ImageRemoveRequest> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ImageRemoveRequestBuilder removeAugmentation(Class<? extends Augmentation<ImageRemoveRequest>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ImageRemoveRequest} instance.
     *
     * @return A new {@link ImageRemoveRequest} instance.
     */
    public @NonNull ImageRemoveRequest build() {
        return new ImageRemoveRequestImpl(this);
    }

    private static final class ImageRemoveRequestImpl
        extends AbstractAugmentable<ImageRemoveRequest>
        implements ImageRemoveRequest {
    
        private final String _imagename;
    
        ImageRemoveRequestImpl(ImageRemoveRequestBuilder base) {
            super(base.augmentation);
            this._imagename = base.getImagename();
        }
    
        @Override
        public String getImagename() {
            return _imagename;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ImageRemoveRequest.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ImageRemoveRequest.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ImageRemoveRequest.bindingToString(this);
        }
    }
}
