package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageinstall.input;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageInstallInput;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>sonic-gnoi-yang</b>
 * <pre>
 * container ImageInstallRequest {
 *   uses ImageInstallRequest;
 * }
 * </pre>
 * <p>To create instances of this class use {@link ImageInstallRequestBuilder}.
 * @see ImageInstallRequestBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ImageInstallRequest
    extends
    ChildOf<ImageInstallInput>,
    Augmentable<ImageInstallRequest>,
    org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageInstallRequest
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ImageInstallRequest");

    @Override
    default Class<org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageinstall.input.ImageInstallRequest> implementedInterface() {
        return org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageinstall.input.ImageInstallRequest.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageinstall.input.@NonNull ImageInstallRequest obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getImagename());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageinstall.input.@NonNull ImageInstallRequest thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageinstall.input.ImageInstallRequest.class, obj);
        return other != null
            && Objects.equals(thisObj.getImagename(), other.getImagename())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageinstall.input.@NonNull ImageInstallRequest obj) {
        final var helper = MoreObjects.toStringHelper("ImageInstallRequest");
        CodeHelpers.appendValue(helper, "imagename", obj.getImagename());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

