package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.clearneighbors.input;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ClearNeighborsRequest} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ClearNeighborsRequest createClearNeighborsRequest(int fooXyzzy, int barBaz) {
 *         return new ClearNeighborsRequestBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ClearNeighborsRequest, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ClearNeighborsRequest
 *
 */
@Generated("mdsal-binding-generator")
public class ClearNeighborsRequestBuilder {

    private String _family;
    private Boolean _force;
    private String _ifname;
    private String _ip;


    Map<Class<? extends Augmentation<ClearNeighborsRequest>>, Augmentation<ClearNeighborsRequest>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ClearNeighborsRequestBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest}.
     *
     * @param arg org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest from which the builder should be initialized
     */
    public ClearNeighborsRequestBuilder(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest arg) {
        this._force = arg.getForce();
        this._family = arg.getFamily();
        this._ip = arg.getIp();
        this._ifname = arg.getIfname();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link ClearNeighborsRequest}.
     *
     * @param base ClearNeighborsRequest from which the builder should be initialized
     */
    public ClearNeighborsRequestBuilder(ClearNeighborsRequest base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._family = base.getFamily();
        this._force = base.getForce();
        this._ifname = base.getIfname();
        this._ip = base.getIp();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest castArg) {
            this._force = castArg.getForce();
            this._family = castArg.getFamily();
            this._ip = castArg.getIp();
            this._ifname = castArg.getIfname();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest]");
    }

    private static final class LazyEmpty {
        static final @NonNull ClearNeighborsRequest INSTANCE = new ClearNeighborsRequestBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of ClearNeighborsRequest.
     *
     * @return An empty {@link ClearNeighborsRequest}
     */
    public static @NonNull ClearNeighborsRequest empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link ClearNeighborsRequest#getFamily()}.
     *
     * @return current value
     */
    public String getFamily() {
        return _family;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ClearNeighborsRequest#getForce()}.
     *
     * @return current value
     */
    public Boolean getForce() {
        return _force;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ClearNeighborsRequest#getIfname()}.
     *
     * @return current value
     */
    public String getIfname() {
        return _ifname;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ClearNeighborsRequest#getIp()}.
     *
     * @return current value
     */
    public String getIp() {
        return _ip;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ClearNeighborsRequest>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ClearNeighborsRequest#getFamily()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ClearNeighborsRequestBuilder setFamily(final String value) {
        this._family = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ClearNeighborsRequest#getForce()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ClearNeighborsRequestBuilder setForce(final Boolean value) {
        this._force = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ClearNeighborsRequest#getIfname()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ClearNeighborsRequestBuilder setIfname(final String value) {
        this._ifname = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ClearNeighborsRequest#getIp()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ClearNeighborsRequestBuilder setIp(final String value) {
        this._ip = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ClearNeighborsRequestBuilder addAugmentation(Augmentation<ClearNeighborsRequest> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ClearNeighborsRequestBuilder removeAugmentation(Class<? extends Augmentation<ClearNeighborsRequest>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ClearNeighborsRequest} instance.
     *
     * @return A new {@link ClearNeighborsRequest} instance.
     */
    public @NonNull ClearNeighborsRequest build() {
        return new ClearNeighborsRequestImpl(this);
    }

    private static final class ClearNeighborsRequestImpl
        extends AbstractAugmentable<ClearNeighborsRequest>
        implements ClearNeighborsRequest {
    
        private final String _family;
        private final Boolean _force;
        private final String _ifname;
        private final String _ip;
    
        ClearNeighborsRequestImpl(ClearNeighborsRequestBuilder base) {
            super(base.augmentation);
            this._family = base.getFamily();
            this._force = base.getForce();
            this._ifname = base.getIfname();
            this._ip = base.getIp();
        }
    
        @Override
        public String getFamily() {
            return _family;
        }
        
        @Override
        public Boolean getForce() {
            return _force;
        }
        
        @Override
        public String getIfname() {
            return _ifname;
        }
        
        @Override
        public String getIp() {
            return _ip;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ClearNeighborsRequest.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ClearNeighborsRequest.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ClearNeighborsRequest.bindingToString(this);
        }
    }
}
