package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.imageremove.input.ImageRemoveRequest;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>sonic-gnoi-yang</b>
 * <pre>
 * input input {
 *   container ImageRemoveRequest {
 *     uses ImageRemoveRequest;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ImageRemoveInput
    extends
    RpcInput,
    Augmentable<ImageRemoveInput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveInput.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.@NonNull ImageRemoveInput obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getImageRemoveRequest());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.@NonNull ImageRemoveInput thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ImageRemoveInput.class, obj);
        return other != null
            && Objects.equals(thisObj.getImageRemoveRequest(), other.getImageRemoveRequest())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.@NonNull ImageRemoveInput obj) {
        final var helper = MoreObjects.toStringHelper("ImageRemoveInput");
        CodeHelpers.appendValue(helper, "imageRemoveRequest", obj.getImageRemoveRequest());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return imageRemoveRequest, or {@code null} if it is not present.
     *
     * @return {@code ImageRemoveRequest} imageRemoveRequest, or {@code null} if it is not present.
     *
     */
    ImageRemoveRequest getImageRemoveRequest();
    
    /**
     * Return imageRemoveRequest, or an empty instance if it is not present.
     *
     * @return {@code ImageRemoveRequest} imageRemoveRequest, or an empty instance if it is not present.
     *
     */
    @NonNull ImageRemoveRequest nonnullImageRemoveRequest();

}

