package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.$YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>sonic-gnoi-yang</b>
 * <pre>
 * container SonicOutput {
 *   leaf status {
 *     type int32;
 *   }
 *   leaf status_detail {
 *     type string;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link SonicOutputBuilder}.
 * @see SonicOutputBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface SonicOutput
    extends
    ChildOf<org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.SonicOutput>,
    Augmentable<SonicOutput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("SonicOutput");

    @Override
    default Class<org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.SonicOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.SonicOutput.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.@NonNull SonicOutput obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getStatus());
        result = prime * result + Objects.hashCode(obj.getStatusDetail());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.@NonNull SonicOutput thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.SonicOutput.class, obj);
        return other != null
            && Objects.equals(thisObj.getStatus(), other.getStatus())
            && Objects.equals(thisObj.getStatusDetail(), other.getStatusDetail())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput.@NonNull SonicOutput obj) {
        final var helper = MoreObjects.toStringHelper("SonicOutput");
        CodeHelpers.appendValue(helper, "status", obj.getStatus());
        CodeHelpers.appendValue(helper, "statusDetail", obj.getStatusDetail());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return status, or {@code null} if it is not present.
     *
     * @return {@code Integer} status, or {@code null} if it is not present.
     *
     */
    Integer getStatus();
    
    /**
     * Return status, guaranteed to be non-null.
     *
     * @return {@code Integer} status, guaranteed to be non-null.
     * @throws NoSuchElementException if status is not present
     *
     */
    default @NonNull Integer requireStatus() {
        return CodeHelpers.require(getStatus(), "status");
    }
    
    /**
     * Return statusDetail, or {@code null} if it is not present.
     *
     * @return {@code String} statusDetail, or {@code null} if it is not present.
     *
     */
    String getStatusDetail();
    
    /**
     * Return statusDetail, guaranteed to be non-null.
     *
     * @return {@code String} statusDetail, guaranteed to be non-null.
     * @throws NoSuchElementException if statusDetail is not present
     *
     */
    default @NonNull String requireStatusDetail() {
        return CodeHelpers.require(getStatusDetail(), "statusdetail");
    }

}

