package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.showtechsupport.output;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TechsupportResponse} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TechsupportResponse createTechsupportResponse(int fooXyzzy, int barBaz) {
 *         return new TechsupportResponseBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TechsupportResponse, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TechsupportResponse
 *
 */
@Generated("mdsal-binding-generator")
public class TechsupportResponseBuilder {

    private String _outputFilename;


    Map<Class<? extends Augmentation<TechsupportResponse>>, Augmentation<TechsupportResponse>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TechsupportResponseBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.TechsupportResponse}.
     *
     * @param arg org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.TechsupportResponse from which the builder should be initialized
     */
    public TechsupportResponseBuilder(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.TechsupportResponse arg) {
        this._outputFilename = arg.getOutputFilename();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link TechsupportResponse}.
     *
     * @param base TechsupportResponse from which the builder should be initialized
     */
    public TechsupportResponseBuilder(TechsupportResponse base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._outputFilename = base.getOutputFilename();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.TechsupportResponse}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.TechsupportResponse) {
            this._outputFilename = ((org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.TechsupportResponse)arg).getOutputFilename();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.TechsupportResponse]");
    }

    /**
     * Return current value associated with the property corresponding to {@link TechsupportResponse#getOutputFilename()}.
     *
     * @return current value
     */
    public String getOutputFilename() {
        return _outputFilename;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<TechsupportResponse>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link TechsupportResponse#getOutputFilename()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TechsupportResponseBuilder setOutputFilename(final String value) {
        this._outputFilename = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TechsupportResponseBuilder addAugmentation(Augmentation<TechsupportResponse> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TechsupportResponseBuilder removeAugmentation(Class<? extends Augmentation<TechsupportResponse>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link TechsupportResponse} instance.
     *
     * @return A new {@link TechsupportResponse} instance.
     */
    public @NonNull TechsupportResponse build() {
        return new TechsupportResponseImpl(this);
    }

    private static final class TechsupportResponseImpl
        extends AbstractAugmentable<TechsupportResponse>
        implements TechsupportResponse {
    
        private final String _outputFilename;
    
        TechsupportResponseImpl(TechsupportResponseBuilder base) {
            super(base.augmentation);
            this._outputFilename = base.getOutputFilename();
        }
    
        @Override
        public String getOutputFilename() {
            return _outputFilename;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TechsupportResponse.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TechsupportResponse.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TechsupportResponse.bindingToString(this);
        }
    }
}
