package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.sonicoutput;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link SonicOutputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SonicOutputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SonicOutputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SonicOutputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SonicOutputBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SonicOutputBuilder implements Builder<SonicOutput> {

    private Integer _status;
    private String _statusDetail;


    Map<Class<? extends Augmentation<SonicOutput>>, Augmentation<SonicOutput>> augmentation = Collections.emptyMap();

    public SonicOutputBuilder() {
    }
    
    

    public SonicOutputBuilder(SonicOutput base) {
        Map<Class<? extends Augmentation<SonicOutput>>, Augmentation<SonicOutput>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._status = base.getStatus();
        this._statusDetail = base.getStatusDetail();
    }


    public Integer getStatus() {
        return _status;
    }
    
    public String getStatusDetail() {
        return _statusDetail;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SonicOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SonicOutputBuilder setStatus(final Integer value) {
        this._status = value;
        return this;
    }
    
    public SonicOutputBuilder setStatusDetail(final String value) {
        this._statusDetail = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SonicOutputBuilder addAugmentation(Augmentation<SonicOutput> augmentation) {
        Class<? extends Augmentation<SonicOutput>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SonicOutputBuilder removeAugmentation(Class<? extends Augmentation<SonicOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SonicOutput build() {
        return new SonicOutputImpl(this);
    }

    private static final class SonicOutputImpl
        extends AbstractAugmentable<SonicOutput>
        implements SonicOutput {
    
        private final Integer _status;
        private final String _statusDetail;
    
        SonicOutputImpl(SonicOutputBuilder base) {
            super(base.augmentation);
            this._status = base.getStatus();
            this._statusDetail = base.getStatusDetail();
        }
    
        @Override
        public Integer getStatus() {
            return _status;
        }
        
        @Override
        public String getStatusDetail() {
            return _statusDetail;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SonicOutput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SonicOutput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SonicOutput.bindingToString(this);
        }
    }
}
