package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.clearneighbors.input;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ClearNeighborsRequestBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ClearNeighborsRequestBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ClearNeighborsRequestBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ClearNeighborsRequestBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ClearNeighborsRequestBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ClearNeighborsRequestBuilder implements Builder<ClearNeighborsRequest> {

    private String _family;
    private Boolean _force;
    private String _ifname;
    private String _ip;


    Map<Class<? extends Augmentation<ClearNeighborsRequest>>, Augmentation<ClearNeighborsRequest>> augmentation = Collections.emptyMap();

    public ClearNeighborsRequestBuilder() {
    }
    
    
    
    public ClearNeighborsRequestBuilder(org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest arg) {
        this._force = arg.getForce();
        this._family = arg.getFamily();
        this._ip = arg.getIp();
        this._ifname = arg.getIfname();
    }

    public ClearNeighborsRequestBuilder(ClearNeighborsRequest base) {
        Map<Class<? extends Augmentation<ClearNeighborsRequest>>, Augmentation<ClearNeighborsRequest>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._family = base.getFamily();
        this._force = base.getForce();
        this._ifname = base.getIfname();
        this._ip = base.getIp();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest) {
            this._force = ((org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest)arg).getForce();
            this._family = ((org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest)arg).getFamily();
            this._ip = ((org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest)arg).getIp();
            this._ifname = ((org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest)arg).getIfname();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614.ClearNeighborsRequest]");
    }

    public String getFamily() {
        return _family;
    }
    
    public Boolean getForce() {
        return _force;
    }
    
    public String getIfname() {
        return _ifname;
    }
    
    public String getIp() {
        return _ip;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ClearNeighborsRequest>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ClearNeighborsRequestBuilder setFamily(final String value) {
        this._family = value;
        return this;
    }
    
    public ClearNeighborsRequestBuilder setForce(final Boolean value) {
        this._force = value;
        return this;
    }
    
    public ClearNeighborsRequestBuilder setIfname(final String value) {
        this._ifname = value;
        return this;
    }
    
    public ClearNeighborsRequestBuilder setIp(final String value) {
        this._ip = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ClearNeighborsRequestBuilder addAugmentation(Augmentation<ClearNeighborsRequest> augmentation) {
        Class<? extends Augmentation<ClearNeighborsRequest>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ClearNeighborsRequestBuilder removeAugmentation(Class<? extends Augmentation<ClearNeighborsRequest>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ClearNeighborsRequest build() {
        return new ClearNeighborsRequestImpl(this);
    }

    private static final class ClearNeighborsRequestImpl
        extends AbstractAugmentable<ClearNeighborsRequest>
        implements ClearNeighborsRequest {
    
        private final String _family;
        private final Boolean _force;
        private final String _ifname;
        private final String _ip;
    
        ClearNeighborsRequestImpl(ClearNeighborsRequestBuilder base) {
            super(base.augmentation);
            this._family = base.getFamily();
            this._force = base.getForce();
            this._ifname = base.getIfname();
            this._ip = base.getIp();
        }
    
        @Override
        public String getFamily() {
            return _family;
        }
        
        @Override
        public Boolean getForce() {
            return _force;
        }
        
        @Override
        public String getIfname() {
            return _ifname;
        }
        
        @Override
        public String getIp() {
            return _ip;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ClearNeighborsRequest.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ClearNeighborsRequest.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ClearNeighborsRequest.bindingToString(this);
        }
    }
}
