package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>sonic-gnoi-yang</b>
 * <pre>
 * grouping CopyConfigRequest {
 *   leaf source {
 *     type string;
 *   }
 *   leaf overwrite {
 *     type boolean;
 *   }
 *   leaf destination {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>sonic-gnoi-yangCopyConfigRequest</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface CopyConfigRequest
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("CopyConfigRequest");

    @Override
    Class<? extends CopyConfigRequest> implementedInterface();
    
    /**
     * Return source, or {@code null} if it is not present.
     *
     * @return {@code String} source, or {@code null} if it is not present.
     *
     */
    String getSource();
    
    /**
     * Return source, guaranteed to be non-null.
     *
     * @return {@code String} source, guaranteed to be non-null.
     * @throws NoSuchElementException if source is not present
     *
     */
    default @NonNull String requireSource() {
        return CodeHelpers.require(getSource(), "source");
    }
    
    /**
     * Return overwrite, or {@code null} if it is not present.
     *
     * @return {@code Boolean} overwrite, or {@code null} if it is not present.
     *
     */
    Boolean getOverwrite();
    
    /**
     * Return overwrite, guaranteed to be non-null.
     *
     * @return {@code Boolean} overwrite, guaranteed to be non-null.
     * @throws NoSuchElementException if overwrite is not present
     *
     */
    default @NonNull Boolean requireOverwrite() {
        return CodeHelpers.require(getOverwrite(), "overwrite");
    }
    
    /**
     * Return destination, or {@code null} if it is not present.
     *
     * @return {@code String} destination, or {@code null} if it is not present.
     *
     */
    String getDestination();
    
    /**
     * Return destination, guaranteed to be non-null.
     *
     * @return {@code String} destination, guaranteed to be non-null.
     * @throws NoSuchElementException if destination is not present
     *
     */
    default @NonNull String requireDestination() {
        return CodeHelpers.require(getDestination(), "destination");
    }

}

