package org.opendaylight.yang.gen.v1.sonic.gnoi.yang.rev210614;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>sonic-gnoi-yang</b>
 * <pre>
 * grouping ClearNeighborsRequest {
 *   leaf force {
 *     type boolean;
 *   }
 *   leaf family {
 *     type string;
 *   }
 *   leaf ip {
 *     type string;
 *   }
 *   leaf ifname {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>sonic-gnoi-yangClearNeighborsRequest</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface ClearNeighborsRequest
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ClearNeighborsRequest");

    @Override
    Class<? extends ClearNeighborsRequest> implementedInterface();
    
    /**
     * Return force, or {@code null} if it is not present.
     *
     * @return {@code Boolean} force, or {@code null} if it is not present.
     *
     */
    Boolean getForce();
    
    /**
     * Return force, guaranteed to be non-null.
     *
     * @return {@code Boolean} force, guaranteed to be non-null.
     * @throws NoSuchElementException if force is not present
     *
     */
    default @NonNull Boolean requireForce() {
        return CodeHelpers.require(getForce(), "force");
    }
    
    /**
     * Return family, or {@code null} if it is not present.
     *
     * @return {@code String} family, or {@code null} if it is not present.
     *
     */
    String getFamily();
    
    /**
     * Return family, guaranteed to be non-null.
     *
     * @return {@code String} family, guaranteed to be non-null.
     * @throws NoSuchElementException if family is not present
     *
     */
    default @NonNull String requireFamily() {
        return CodeHelpers.require(getFamily(), "family");
    }
    
    /**
     * Return ip, or {@code null} if it is not present.
     *
     * @return {@code String} ip, or {@code null} if it is not present.
     *
     */
    String getIp();
    
    /**
     * Return ip, guaranteed to be non-null.
     *
     * @return {@code String} ip, guaranteed to be non-null.
     * @throws NoSuchElementException if ip is not present
     *
     */
    default @NonNull String requireIp() {
        return CodeHelpers.require(getIp(), "ip");
    }
    
    /**
     * Return ifname, or {@code null} if it is not present.
     *
     * @return {@code String} ifname, or {@code null} if it is not present.
     *
     */
    String getIfname();
    
    /**
     * Return ifname, guaranteed to be non-null.
     *
     * @return {@code String} ifname, guaranteed to be non-null.
     * @throws NoSuchElementException if ifname is not present
     *
     */
    default @NonNull String requireIfname() {
        return CodeHelpers.require(getIfname(), "ifname");
    }

}

