package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.gnmi.yang.models;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.ModuleVersionType;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link GnmiYangModel} class.
 *
 * @see GnmiYangModel
 *
 */
@Generated("mdsal-binding-generator")
public class GnmiYangModelKey
 implements Key<GnmiYangModel> {
    @java.io.Serial
    private static final long serialVersionUID = 4624226331577244173L;
    private final String _name;
    private final ModuleVersionType _version;


    /**
     * Constructs an instance.
     *
     * @param _name the entity name
     * @param _version the entity version
     * @throws NullPointerException if any of the arguments are null
     */
    public GnmiYangModelKey(@NonNull String _name, @NonNull ModuleVersionType _version) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
        this._version = CodeHelpers.requireKeyProp(_version, "version");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public GnmiYangModelKey(GnmiYangModelKey source) {
        this._name = source._name;
        this._version = source._version;
    }


    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     */
    public @NonNull String getName() {
        return _name;
    }
    
    /**
     * Return version, guaranteed to be non-null.
     *
     * @return {@code ModuleVersionType} version, guaranteed to be non-null.
     */
    public @NonNull ModuleVersionType getVersion() {
        return _version;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_name);
        result = prime * result + Objects.hashCode(_version);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof GnmiYangModelKey other
            && Objects.equals(_name, other._name)        
            && Objects.equals(_version, other._version);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(GnmiYangModelKey.class);
        CodeHelpers.appendValue(helper, "name", _name);
        CodeHelpers.appendValue(helper, "version", _version);
        return helper.toString();
    }
}

