package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.gnmi.yang.models;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.ModuleVersionType;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.YangModel;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.YangModelNameVersion;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GnmiYangModel} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GnmiYangModel createGnmiYangModel(int fooXyzzy, int barBaz) {
 *         return new GnmiYangModelBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GnmiYangModel, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GnmiYangModel
 *
 */
@Generated("mdsal-binding-generator")
public class GnmiYangModelBuilder {

    private String _body;
    private String _name;
    private ModuleVersionType _version;
    private GnmiYangModelKey key;


    Map<Class<? extends Augmentation<GnmiYangModel>>, Augmentation<GnmiYangModel>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public GnmiYangModelBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link YangModel}.
     *
     * @param arg YangModel from which the builder should be initialized
     */
    public GnmiYangModelBuilder(YangModel arg) {
        this._body = arg.getBody();
        this._name = arg.getName();
        this._version = arg.getVersion();
    }
    
    /**
     * Construct a new builder initialized from specified {@link YangModelNameVersion}.
     *
     * @param arg YangModelNameVersion from which the builder should be initialized
     */
    public GnmiYangModelBuilder(YangModelNameVersion arg) {
        this._name = arg.getName();
        this._version = arg.getVersion();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link GnmiYangModel}.
     *
     * @param base GnmiYangModel from which the builder should be initialized
     */
    public GnmiYangModelBuilder(GnmiYangModel base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._version = base.getVersion();
        this._body = base.getBody();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link YangModel}</li>
     *   <li>{@link YangModelNameVersion}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof YangModel castArg) {
            this._body = castArg.getBody();
            isValidArg = true;
        }
        if (arg instanceof YangModelNameVersion castArg) {
            this._name = castArg.getName();
            this._version = castArg.getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[YangModel, YangModelNameVersion]");
    }


    /**
     * Return current value associated with the property corresponding to {@link GnmiYangModel#key()}.
     *
     * @return current value
     */
    public GnmiYangModelKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link GnmiYangModel#getBody()}.
     *
     * @return current value
     */
    public String getBody() {
        return _body;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link GnmiYangModel#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link GnmiYangModel#getVersion()}.
     *
     * @return current value
     */
    public ModuleVersionType getVersion() {
        return _version;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GnmiYangModel>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link GnmiYangModel#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public GnmiYangModelBuilder withKey(final GnmiYangModelKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link GnmiYangModel#getBody()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GnmiYangModelBuilder setBody(final String value) {
        this._body = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link GnmiYangModel#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GnmiYangModelBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link GnmiYangModel#getVersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GnmiYangModelBuilder setVersion(final ModuleVersionType value) {
        this._version = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GnmiYangModelBuilder addAugmentation(Augmentation<GnmiYangModel> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GnmiYangModelBuilder removeAugmentation(Class<? extends Augmentation<GnmiYangModel>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link GnmiYangModel} instance.
     *
     * @return A new {@link GnmiYangModel} instance.
     */
    public @NonNull GnmiYangModel build() {
        return new GnmiYangModelImpl(this);
    }

    private static final class GnmiYangModelImpl
        extends AbstractAugmentable<GnmiYangModel>
        implements GnmiYangModel {
    
        private final String _body;
        private final String _name;
        private final ModuleVersionType _version;
        private final GnmiYangModelKey key;
    
        GnmiYangModelImpl(GnmiYangModelBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new GnmiYangModelKey(base.getName(), base.getVersion());
            }
            this._name = key.getName();
            this._version = key.getVersion();
            this._body = base.getBody();
        }
    
        @Override
        public GnmiYangModelKey key() {
            return key;
        }
        
        @Override
        public String getBody() {
            return _body;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public ModuleVersionType getVersion() {
            return _version;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GnmiYangModel.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GnmiYangModel.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GnmiYangModel.bindingToString(this);
        }
    }
}
