package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.lighty.gnmi.yang.storage.rev210331.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-yang-storage</b>
 * <pre>
 * grouping yang-model-name-version {
 *   leaf name {
 *     type string;
 *   }
 *   leaf version {
 *     type module-version-type;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface YangModelNameVersion
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("yang-model-name-version");

    @Override
    Class<? extends YangModelNameVersion> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name of the yang model
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name of the yang model
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return version, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Version of the yang model
     *     </code>
     * </pre>
     *
     * @return {@code ModuleVersionType} version, or {@code null} if it is not present.
     *
     */
    ModuleVersionType getVersion();
    
    /**
     * Return version, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Version of the yang model
     *     </code>
     * </pre>
     *
     * @return {@code ModuleVersionType} version, guaranteed to be non-null.
     * @throws NoSuchElementException if version is not present
     *
     */
    default @NonNull ModuleVersionType requireVersion() {
        return CodeHelpers.require(getVersion(), "version");
    }

}

