package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.lighty.gnmi.yang.storage.rev210331.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-yang-storage</b>
 * <pre>
 * grouping yang-model {
 *   uses yang-model-name-version;
 *   leaf body {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface YangModel
    extends
    DataObject,
    YangModelNameVersion
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("yang-model");

    @Override
    Class<? extends YangModel> implementedInterface();
    
    /**
     * Return body, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Body of the yang model
     *     </code>
     * </pre>
     *
     * @return {@code String} body, or {@code null} if it is not present.
     *
     */
    String getBody();
    
    /**
     * Return body, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Body of the yang model
     *     </code>
     * </pre>
     *
     * @return {@code String} body, guaranteed to be non-null.
     * @throws NoSuchElementException if body is not present
     *
     */
    default @NonNull String requireBody() {
        return CodeHelpers.require(getBody(), "body");
    }

}

