package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.gnmi.yang.models.GnmiYangModel;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.gnmi.yang.models.GnmiYangModelKey;
import org.opendaylight.yang.svc.v1.urn.lighty.gnmi.yang.storage.rev210331.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-yang-storage</b>
 * <pre>
 * container gnmi-yang-models {
 *   list gnmi-yang-model {
 *     key "name version";
 *     config false;
 *     uses yang-model;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link GnmiYangModelsBuilder}.
 * @see GnmiYangModelsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface GnmiYangModels
    extends
    ChildOf<GnmiYangStorageData>,
    Augmentable<GnmiYangModels>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("gnmi-yang-models");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.GnmiYangModels> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.GnmiYangModels.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.@NonNull GnmiYangModels obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getGnmiYangModel());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.@NonNull GnmiYangModels thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.GnmiYangModels.class, obj);
        return other != null
            && Objects.equals(thisObj.getGnmiYangModel(), other.getGnmiYangModel())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.@NonNull GnmiYangModels obj) {
        final var helper = MoreObjects.toStringHelper("GnmiYangModels");
        CodeHelpers.appendValue(helper, "gnmiYangModel", obj.getGnmiYangModel());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return gnmiYangModel, or {@code null} if it is not present.
     *
     * @return {@code Map<GnmiYangModelKey, GnmiYangModel>} gnmiYangModel, or {@code null} if it is not present.
     *
     */
    @Nullable Map<GnmiYangModelKey, GnmiYangModel> getGnmiYangModel();
    
    /**
     * Return gnmiYangModel, or an empty list if it is not present.
     *
     * @return {@code Map<GnmiYangModelKey, GnmiYangModel>} gnmiYangModel, or an empty list if it is not present.
     *
     */
    default @NonNull Map<GnmiYangModelKey, GnmiYangModel> nonnullGnmiYangModel() {
        return CodeHelpers.nonnull(getGnmiYangModel());
    }

}

