package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link UploadYangModelInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UploadYangModelInput createUploadYangModelInput(int fooXyzzy, int barBaz) {
 *         return new UploadYangModelInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UploadYangModelInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UploadYangModelInput
 *
 */
@Generated("mdsal-binding-generator")
public class UploadYangModelInputBuilder {

    private String _body;
    private String _name;
    private ModuleVersionType _version;


    Map<Class<? extends Augmentation<UploadYangModelInput>>, Augmentation<UploadYangModelInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UploadYangModelInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link YangModel}.
     *
     * @param arg YangModel from which the builder should be initialized
     */
    public UploadYangModelInputBuilder(YangModel arg) {
        this._body = arg.getBody();
        this._name = arg.getName();
        this._version = arg.getVersion();
    }
    
    /**
     * Construct a new builder initialized from specified {@link YangModelNameVersion}.
     *
     * @param arg YangModelNameVersion from which the builder should be initialized
     */
    public UploadYangModelInputBuilder(YangModelNameVersion arg) {
        this._name = arg.getName();
        this._version = arg.getVersion();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link UploadYangModelInput}.
     *
     * @param base UploadYangModelInput from which the builder should be initialized
     */
    public UploadYangModelInputBuilder(UploadYangModelInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._body = base.getBody();
        this._name = base.getName();
        this._version = base.getVersion();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link YangModel}</li>
     *   <li>{@link YangModelNameVersion}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof YangModel) {
            this._body = ((YangModel)arg).getBody();
            isValidArg = true;
        }
        if (arg instanceof YangModelNameVersion) {
            this._name = ((YangModelNameVersion)arg).getName();
            this._version = ((YangModelNameVersion)arg).getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[YangModel, YangModelNameVersion]");
    }

    /**
     * Return current value associated with the property corresponding to {@link UploadYangModelInput#getBody()}.
     *
     * @return current value
     */
    public String getBody() {
        return _body;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UploadYangModelInput#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UploadYangModelInput#getVersion()}.
     *
     * @return current value
     */
    public ModuleVersionType getVersion() {
        return _version;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UploadYangModelInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link UploadYangModelInput#getBody()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UploadYangModelInputBuilder setBody(final String value) {
        this._body = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UploadYangModelInput#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UploadYangModelInputBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UploadYangModelInput#getVersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UploadYangModelInputBuilder setVersion(final ModuleVersionType value) {
        this._version = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UploadYangModelInputBuilder addAugmentation(Augmentation<UploadYangModelInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UploadYangModelInputBuilder removeAugmentation(Class<? extends Augmentation<UploadYangModelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link UploadYangModelInput} instance.
     *
     * @return A new {@link UploadYangModelInput} instance.
     */
    public @NonNull UploadYangModelInput build() {
        return new UploadYangModelInputImpl(this);
    }

    private static final class UploadYangModelInputImpl
        extends AbstractAugmentable<UploadYangModelInput>
        implements UploadYangModelInput {
    
        private final String _body;
        private final String _name;
        private final ModuleVersionType _version;
    
        UploadYangModelInputImpl(UploadYangModelInputBuilder base) {
            super(base.augmentation);
            this._body = base.getBody();
            this._name = base.getName();
            this._version = base.getVersion();
        }
    
        @Override
        public String getBody() {
            return _body;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public ModuleVersionType getVersion() {
            return _version;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = UploadYangModelInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return UploadYangModelInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return UploadYangModelInput.bindingToString(this);
        }
    }
}
