package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Model used for storing yang models from which schema contexts of gNMI devices 
 * are constructed. Copyright (c) 2021 PANTHEON.tech s.r.o. All Rights Reserved. 
 * This program and the accompanying materials are made available under the terms 
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at https://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-yang-storage</b>
 * <pre>
 * module gnmi-yang-storage {
 *   yang-version 1;
 *   namespace urn:lighty:gnmi:yang:storage;
 *   prefix gnmi-ys;
 *   revision 2021-03-31 {
 *   }
 *   typedef module-version-type {
 *     type string;
 *   }
 *   grouping yang-model-name-version {
 *     leaf name {
 *       type string;
 *     }
 *     leaf version {
 *       type module-version-type;
 *     }
 *   }
 *   grouping yang-model {
 *     uses yang-model-name-version;
 *     leaf body {
 *       type string;
 *     }
 *   }
 *   container gnmi-yang-models {
 *     list gnmi-yang-model {
 *       key "name version";
 *       config false;
 *       uses yang-model;
 *     }
 *   }
 *   rpc upload-yang-model {
 *     input input {
 *       uses yang-model;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface GnmiYangStorageData
    extends
    DataRoot
{




    /**
     * Return gnmiYangModels, or {@code null} if it is not present.
     *
     * @return {@code GnmiYangModels} gnmiYangModels, or {@code null} if it is not present.
     *
     */
    GnmiYangModels getGnmiYangModels();

}

