package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.gnmi.yang.models;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.ModuleVersionType;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

@Generated("mdsal-binding-generator")
public class GnmiYangModelKey
 implements Identifier<GnmiYangModel> {
    private static final long serialVersionUID = -9071651171762039110L;
    private final String _name;
    private final ModuleVersionType _version;


    public GnmiYangModelKey(@NonNull String _name, @NonNull ModuleVersionType _version) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
        this._version = CodeHelpers.requireKeyProp(_version, "version");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public GnmiYangModelKey(GnmiYangModelKey source) {
        this._name = source._name;
        this._version = source._version;
    }


    public @NonNull String getName() {
        return _name;
    }
    
    public @NonNull ModuleVersionType getVersion() {
        return _version;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_name);
        result = prime * result + Objects.hashCode(_version);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GnmiYangModelKey)) {
            return false;
        }
        final GnmiYangModelKey other = (GnmiYangModelKey) obj;
        if (!Objects.equals(_name, other._name)) {
            return false;
        }
        if (!Objects.equals(_version, other._version)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(GnmiYangModelKey.class);
        CodeHelpers.appendValue(helper, "_name", _name);
        CodeHelpers.appendValue(helper, "_version", _version);
        return helper.toString();
    }
}

