package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.gnmi.yang.models.GnmiYangModel;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.yang.storage.rev210331.gnmi.yang.models.GnmiYangModelKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link GnmiYangModels} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GnmiYangModels createGnmiYangModels(int fooXyzzy, int barBaz) {
 *         return new GnmiYangModelsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GnmiYangModels, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GnmiYangModels
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class GnmiYangModelsBuilder implements Builder<GnmiYangModels> {

    private Map<GnmiYangModelKey, GnmiYangModel> _gnmiYangModel;


    Map<Class<? extends Augmentation<GnmiYangModels>>, Augmentation<GnmiYangModels>> augmentation = Collections.emptyMap();

    public GnmiYangModelsBuilder() {
    }
    
    

    public GnmiYangModelsBuilder(GnmiYangModels base) {
        Map<Class<? extends Augmentation<GnmiYangModels>>, Augmentation<GnmiYangModels>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._gnmiYangModel = base.getGnmiYangModel();
    }


    public Map<GnmiYangModelKey, GnmiYangModel> getGnmiYangModel() {
        return _gnmiYangModel;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GnmiYangModels>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GnmiYangModelsBuilder setGnmiYangModel(final Map<GnmiYangModelKey, GnmiYangModel> values) {
        this._gnmiYangModel = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GnmiYangModelsBuilder addAugmentation(Augmentation<GnmiYangModels> augmentation) {
        Class<? extends Augmentation<GnmiYangModels>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GnmiYangModelsBuilder removeAugmentation(Class<? extends Augmentation<GnmiYangModels>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GnmiYangModels build() {
        return new GnmiYangModelsImpl(this);
    }

    private static final class GnmiYangModelsImpl
        extends AbstractAugmentable<GnmiYangModels>
        implements GnmiYangModels {
    
        private final Map<GnmiYangModelKey, GnmiYangModel> _gnmiYangModel;
    
        GnmiYangModelsImpl(GnmiYangModelsBuilder base) {
            super(base.augmentation);
            this._gnmiYangModel = CodeHelpers.emptyToNull(base.getGnmiYangModel());
        }
    
        @Override
        public Map<GnmiYangModelKey, GnmiYangModel> getGnmiYangModel() {
            return _gnmiYangModel;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GnmiYangModels.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GnmiYangModels.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GnmiYangModels.bindingToString(this);
        }
    }
}
