/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNodeState;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state.AvailableCapabilities;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

public interface NodeState
extends ChildOf<GnmiNodeState>,
Augmentable<NodeState> {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("node-state");

    default public Class<NodeState> implementedInterface() {
        return NodeState.class;
    }

    public static int bindingHashCode(@NonNull NodeState obj) {
        int result = 1;
        int prime = 31;
        result = 31 * result + Objects.hashCode(obj.getAvailableCapabilities());
        result = 31 * result + Objects.hashCode(obj.getFailureDetails());
        result = 31 * result + Objects.hashCode((Object)obj.getNodeStatus());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull NodeState thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        NodeState other = (NodeState)CodeHelpers.checkCast(NodeState.class, (Object)obj);
        return other != null && Objects.equals(thisObj.getFailureDetails(), other.getFailureDetails()) && Objects.equals(thisObj.getAvailableCapabilities(), other.getAvailableCapabilities()) && Objects.equals((Object)thisObj.getNodeStatus(), (Object)other.getNodeStatus()) && thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull NodeState obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NodeState");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"availableCapabilities", (Object)obj.getAvailableCapabilities());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"failureDetails", (Object)obj.getFailureDetails());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"nodeStatus", (Object)((Object)obj.getNodeStatus()));
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public NodeStatus getNodeStatus();

    default public @NonNull NodeStatus requireNodeStatus() {
        return (NodeStatus)((Object)CodeHelpers.require((Object)((Object)this.getNodeStatus()), (String)"nodestatus"));
    }

    public String getFailureDetails();

    default public @NonNull String requireFailureDetails() {
        return (String)CodeHelpers.require((Object)this.getFailureDetails(), (String)"failuredetails");
    }

    public AvailableCapabilities getAvailableCapabilities();

    public @NonNull AvailableCapabilities nonnullAvailableCapabilities();

    public static enum NodeStatus implements EnumTypeObject
    {
        READY(0, "READY"),
        CONNECTING(1, "CONNECTING"),
        TRANSIENTFAILURE(2, "TRANSIENT_FAILURE"),
        IDLE(3, "IDLE"),
        SHUTDOWN(4, "SHUTDOWN"),
        FAILURE(5, "FAILURE");

        private final @NonNull String name;
        private final int value;

        private NodeStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable NodeStatus forName(String name) {
            return switch (name) {
                case "READY" -> READY;
                case "CONNECTING" -> CONNECTING;
                case "TRANSIENT_FAILURE" -> TRANSIENTFAILURE;
                case "IDLE" -> IDLE;
                case "SHUTDOWN" -> SHUTDOWN;
                case "FAILURE" -> FAILURE;
                default -> null;
            };
        }

        public static @Nullable NodeStatus forValue(int intValue) {
            return switch (intValue) {
                case 0 -> READY;
                case 1 -> CONNECTING;
                case 2 -> TRANSIENTFAILURE;
                case 3 -> IDLE;
                case 4 -> SHUTDOWN;
                case 5 -> FAILURE;
                default -> null;
            };
        }

        public static @NonNull NodeStatus ofName(String name) {
            return (NodeStatus)CodeHelpers.checkEnum((EnumTypeObject)NodeStatus.forName(name), (String)name);
        }

        public static @NonNull NodeStatus ofValue(int intValue) {
            return (NodeStatus)CodeHelpers.checkEnum((EnumTypeObject)NodeStatus.forValue(intValue), (int)intValue);
        }
    }
}

