package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * container gnmi-parameters {
 *   leaf overwrite-data-type {
 *     type enumeration {
 *       enum ALL;
 *       enum CONFIG;
 *       enum STATE;
 *       enum OPERATIONAL;
 *       enum UNRECOGNIZED;
 *       enum NONE;
 *     }
 *   }
 *   leaf use-model-name-prefix {
 *     type boolean;
 *     default false;
 *   }
 *   leaf path-target {
 *     type string;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link GnmiParametersBuilder}.
 * @see GnmiParametersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface GnmiParameters
    extends
    ChildOf<ExtensionsParameters>,
    Augmentable<GnmiParameters>
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
     * <pre>
     * leaf overwrite-data-type {
     *   type enumeration {
     *     enum ALL;
     *     enum CONFIG;
     *     enum STATE;
     *     enum OPERATIONAL;
     *     enum UNRECOGNIZED;
     *     enum NONE;
     *   }
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum OverwriteDataType implements EnumTypeObject {
        ALL(0, "ALL"),
        
        CONFIG(1, "CONFIG"),
        
        STATE(2, "STATE"),
        
        OPERATIONAL(3, "OPERATIONAL"),
        
        UNRECOGNIZED(4, "UNRECOGNIZED"),
        
        NONE(5, "NONE")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private OverwriteDataType(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding OverwriteDataType item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable OverwriteDataType forName(String name) {
            return switch (name) {
                case "ALL" -> ALL;
                case "CONFIG" -> CONFIG;
                case "STATE" -> STATE;
                case "OPERATIONAL" -> OPERATIONAL;
                case "UNRECOGNIZED" -> UNRECOGNIZED;
                case "NONE" -> NONE;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding OverwriteDataType item, or {@code null} if no such item exists
         */
        public static @Nullable OverwriteDataType forValue(int intValue) {
            return switch (intValue) {
                case 0 -> ALL;
                case 1 -> CONFIG;
                case 2 -> STATE;
                case 3 -> OPERATIONAL;
                case 4 -> UNRECOGNIZED;
                case 5 -> NONE;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding OverwriteDataType item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull OverwriteDataType ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding OverwriteDataType item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull OverwriteDataType ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("gnmi-parameters");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.@NonNull GnmiParameters obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getOverwriteDataType());
        result = prime * result + Objects.hashCode(obj.getPathTarget());
        result = prime * result + Objects.hashCode(obj.getUseModelNamePrefix());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.@NonNull GnmiParameters thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters.class, obj);
        return other != null
            && Objects.equals(thisObj.getUseModelNamePrefix(), other.getUseModelNamePrefix())
            && Objects.equals(thisObj.getPathTarget(), other.getPathTarget())
            && Objects.equals(thisObj.getOverwriteDataType(), other.getOverwriteDataType())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.@NonNull GnmiParameters obj) {
        final var helper = MoreObjects.toStringHelper("GnmiParameters");
        CodeHelpers.appendValue(helper, "overwriteDataType", obj.getOverwriteDataType());
        CodeHelpers.appendValue(helper, "pathTarget", obj.getPathTarget());
        CodeHelpers.appendValue(helper, "useModelNamePrefix", obj.getUseModelNamePrefix());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return overwriteDataType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Overwrites the type field of gNMI GetRequest. If not set, the type field is
     *         automatically set to CONFIG/STATE based on the RESTCONF content query parameter.
     *         This setting is useful in cases where the device does not support GetRequest
     *         with CONFIG/STATE type field.
     *     </code>
     * </pre>
     *
     * @return {@code OverwriteDataType} overwriteDataType, or {@code null} if it is not present.
     *
     */
    OverwriteDataType getOverwriteDataType();
    
    /**
     * Return overwriteDataType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Overwrites the type field of gNMI GetRequest. If not set, the type field is
     *         automatically set to CONFIG/STATE based on the RESTCONF content query parameter.
     *         This setting is useful in cases where the device does not support GetRequest
     *         with CONFIG/STATE type field.
     *     </code>
     * </pre>
     *
     * @return {@code OverwriteDataType} overwriteDataType, guaranteed to be non-null.
     * @throws NoSuchElementException if overwriteDataType is not present
     *
     */
    default @NonNull OverwriteDataType requireOverwriteDataType() {
        return CodeHelpers.require(getOverwriteDataType(), "overwritedatatype");
    }
    
    /**
     * Return useModelNamePrefix, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Some devices require a module prefix in first element name of gNMI request path
     *         (e.g interfaces -&amp;gt; openconfig-interfaces:interfaces). When flag
     *         use-model-name-prefix is set to true for device, YIID will be transformed into
     *         gNMI path where elements have their module name. E.g. element interfaces from
     *         module openconfig-interfaces will be transformed as
     *         openconfig-interfaces:interfaces
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useModelNamePrefix, or {@code null} if it is not present.
     *
     */
    Boolean getUseModelNamePrefix();
    
    /**
     * Return useModelNamePrefix, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Some devices require a module prefix in first element name of gNMI request path
     *         (e.g interfaces -&amp;gt; openconfig-interfaces:interfaces). When flag
     *         use-model-name-prefix is set to true for device, YIID will be transformed into
     *         gNMI path where elements have their module name. E.g. element interfaces from
     *         module openconfig-interfaces will be transformed as
     *         openconfig-interfaces:interfaces
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useModelNamePrefix, guaranteed to be non-null.
     * @throws NoSuchElementException if useModelNamePrefix is not present
     *
     */
    default @NonNull Boolean requireUseModelNamePrefix() {
        return CodeHelpers.require(getUseModelNamePrefix(), "usemodelnameprefix");
    }
    
    /**
     * Return pathTarget, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The path-target field is used to specify the context of a particular stream of
     *         data. The data stream can be intended for individual target datastores. Only set
     *         in prefix for a path. This field MUST only ever be present on prefix paths in
     *         the corresponding request and response messages. This field is optional for
     *         clients.
     *     </code>
     * </pre>
     *
     * @return {@code String} pathTarget, or {@code null} if it is not present.
     *
     */
    String getPathTarget();
    
    /**
     * Return pathTarget, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The path-target field is used to specify the context of a particular stream of
     *         data. The data stream can be intended for individual target datastores. Only set
     *         in prefix for a path. This field MUST only ever be present on prefix paths in
     *         the corresponding request and response messages. This field is optional for
     *         clients.
     *     </code>
     * </pre>
     *
     * @return {@code String} pathTarget, guaranteed to be non-null.
     * @throws NoSuchElementException if pathTarget is not present
     *
     */
    default @NonNull String requirePathTarget() {
        return CodeHelpers.require(getPathTarget(), "pathtarget");
    }

}

