package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.SecurityChoice;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ConnectionParameters} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ConnectionParameters createConnectionParameters(int fooXyzzy, int barBaz) {
 *         return new ConnectionParametersBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ConnectionParameters, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ConnectionParameters
 *
 */
@Generated("mdsal-binding-generator")
public class ConnectionParametersBuilder {

    private Credentials _credentials;
    private Host _host;
    private PortNumber _port;
    private SecurityChoice _securityChoice;


    Map<Class<? extends Augmentation<ConnectionParameters>>, Augmentation<ConnectionParameters>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConnectionParametersBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link Security}.
     *
     * @param arg Security from which the builder should be initialized
     */
    public ConnectionParametersBuilder(Security arg) {
        this._securityChoice = arg.getSecurityChoice();
        this._credentials = arg.getCredentials();
    }
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials from which the builder should be initialized
     */
    public ConnectionParametersBuilder(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials arg) {
        this._credentials = arg.getCredentials();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link ConnectionParameters}.
     *
     * @param base ConnectionParameters from which the builder should be initialized
     */
    public ConnectionParametersBuilder(ConnectionParameters base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._credentials = base.getCredentials();
        this._host = base.getHost();
        this._port = base.getPort();
        this._securityChoice = base.getSecurityChoice();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials}</li>
     *   <li>{@link Security}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials castArg) {
            this._credentials = castArg.getCredentials();
            isValidArg = true;
        }
        if (arg instanceof Security castArg) {
            this._securityChoice = castArg.getSecurityChoice();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials, Security]");
    }

    private static final class LazyEmpty {
        static final @NonNull ConnectionParameters INSTANCE = new ConnectionParametersBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of ConnectionParameters.
     *
     * @return An empty {@link ConnectionParameters}
     */
    public static @NonNull ConnectionParameters empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link ConnectionParameters#getCredentials()}.
     *
     * @return current value
     */
    public Credentials getCredentials() {
        return _credentials;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ConnectionParameters#getHost()}.
     *
     * @return current value
     */
    public Host getHost() {
        return _host;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ConnectionParameters#getPort()}.
     *
     * @return current value
     */
    public PortNumber getPort() {
        return _port;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ConnectionParameters#getSecurityChoice()}.
     *
     * @return current value
     */
    public SecurityChoice getSecurityChoice() {
        return _securityChoice;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ConnectionParameters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ConnectionParameters#getCredentials()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConnectionParametersBuilder setCredentials(final Credentials value) {
        this._credentials = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ConnectionParameters#getHost()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConnectionParametersBuilder setHost(final Host value) {
        this._host = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ConnectionParameters#getPort()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConnectionParametersBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ConnectionParameters#getSecurityChoice()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConnectionParametersBuilder setSecurityChoice(final SecurityChoice value) {
        this._securityChoice = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConnectionParametersBuilder addAugmentation(Augmentation<ConnectionParameters> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConnectionParametersBuilder removeAugmentation(Class<? extends Augmentation<ConnectionParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ConnectionParameters} instance.
     *
     * @return A new {@link ConnectionParameters} instance.
     */
    public @NonNull ConnectionParameters build() {
        return new ConnectionParametersImpl(this);
    }

    private static final class ConnectionParametersImpl
        extends AbstractAugmentable<ConnectionParameters>
        implements ConnectionParameters {
    
        private final Credentials _credentials;
        private final Host _host;
        private final PortNumber _port;
        private final SecurityChoice _securityChoice;
    
        ConnectionParametersImpl(ConnectionParametersBuilder base) {
            super(base.augmentation);
            this._credentials = base.getCredentials();
            this._host = base.getHost();
            this._port = base.getPort();
            this._securityChoice = base.getSecurityChoice();
        }
    
        @Override
        public Credentials getCredentials() {
            return _credentials;
        }
        
        @Override
        public Host getHost() {
            return _host;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
        
        @Override
        public SecurityChoice getSecurityChoice() {
            return _securityChoice;
        }
    
        @Override
        public Credentials nonnullCredentials() {
            return Objects.requireNonNullElse(getCredentials(), org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.CredentialsBuilder.empty());
        }
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ConnectionParameters.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ConnectionParameters.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ConnectionParameters.bindingToString(this);
        }
    }
}
