package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state.AvailableCapabilities;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link NodeState} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NodeState createNodeState(int fooXyzzy, int barBaz) {
 *         return new NodeStateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NodeState, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NodeState
 *
 */
@Generated("mdsal-binding-generator")
public class NodeStateBuilder {

    private AvailableCapabilities _availableCapabilities;
    private String _failureDetails;
    private NodeState.NodeStatus _nodeStatus;


    Map<Class<? extends Augmentation<NodeState>>, Augmentation<NodeState>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public NodeStateBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link NodeState}.
     *
     * @param base NodeState from which the builder should be initialized
     */
    public NodeStateBuilder(NodeState base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._availableCapabilities = base.getAvailableCapabilities();
        this._failureDetails = base.getFailureDetails();
        this._nodeStatus = base.getNodeStatus();
    }


    private static final class LazyEmpty {
        static final @NonNull NodeState INSTANCE = new NodeStateBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of NodeState.
     *
     * @return An empty {@link NodeState}
     */
    public static @NonNull NodeState empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link NodeState#getAvailableCapabilities()}.
     *
     * @return current value
     */
    public AvailableCapabilities getAvailableCapabilities() {
        return _availableCapabilities;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NodeState#getFailureDetails()}.
     *
     * @return current value
     */
    public String getFailureDetails() {
        return _failureDetails;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NodeState#getNodeStatus()}.
     *
     * @return current value
     */
    public NodeState.NodeStatus getNodeStatus() {
        return _nodeStatus;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NodeState>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link NodeState#getAvailableCapabilities()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NodeStateBuilder setAvailableCapabilities(final AvailableCapabilities value) {
        this._availableCapabilities = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NodeState#getFailureDetails()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NodeStateBuilder setFailureDetails(final String value) {
        this._failureDetails = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NodeState#getNodeStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NodeStateBuilder setNodeStatus(final NodeState.NodeStatus value) {
        this._nodeStatus = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NodeStateBuilder addAugmentation(Augmentation<NodeState> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NodeStateBuilder removeAugmentation(Class<? extends Augmentation<NodeState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link NodeState} instance.
     *
     * @return A new {@link NodeState} instance.
     */
    public @NonNull NodeState build() {
        return new NodeStateImpl(this);
    }

    private static final class NodeStateImpl
        extends AbstractAugmentable<NodeState>
        implements NodeState {
    
        private final AvailableCapabilities _availableCapabilities;
        private final String _failureDetails;
        private final NodeState.NodeStatus _nodeStatus;
    
        NodeStateImpl(NodeStateBuilder base) {
            super(base.augmentation);
            this._availableCapabilities = base.getAvailableCapabilities();
            this._failureDetails = base.getFailureDetails();
            this._nodeStatus = base.getNodeStatus();
        }
    
        @Override
        public AvailableCapabilities getAvailableCapabilities() {
            return _availableCapabilities;
        }
        
        @Override
        public String getFailureDetails() {
            return _failureDetails;
        }
        
        @Override
        public NodeState.NodeStatus getNodeStatus() {
            return _nodeStatus;
        }
    
        @Override
        public AvailableCapabilities nonnullAvailableCapabilities() {
            return Objects.requireNonNullElse(getAvailableCapabilities(), org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state.AvailableCapabilitiesBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NodeState.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NodeState.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NodeState.bindingToString(this);
        }
    }
}
