package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * container credentials {
 *   leaf username {
 *     type string;
 *   }
 *   leaf password {
 *     type string;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link CredentialsBuilder}.
 * @see CredentialsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Credentials
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials>,
    Augmentable<Credentials>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("credentials");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.@NonNull Credentials obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getPassword());
        result = prime * result + Objects.hashCode(obj.getUsername());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.@NonNull Credentials thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPassword(), other.getPassword())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUsername(), other.getUsername())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.@NonNull Credentials obj) {
        final var helper = MoreObjects.toStringHelper("Credentials");
        CodeHelpers.appendValue(helper, "password", obj.getPassword());
        CodeHelpers.appendValue(helper, "username", obj.getUsername());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return username, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         specify the target username as part of the user credentials.
     *     </code>
     * </pre>
     *
     * @return {@code String} username, or {@code null} if it is not present.
     *
     */
    String getUsername();
    
    /**
     * Return username, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         specify the target username as part of the user credentials.
     *     </code>
     * </pre>
     *
     * @return {@code String} username, guaranteed to be non-null.
     * @throws NoSuchElementException if username is not present
     *
     */
    default @NonNull String requireUsername() {
        return CodeHelpers.require(getUsername(), "username");
    }
    
    /**
     * Return password, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         specify the target password as part of the user credentials.
     *     </code>
     * </pre>
     *
     * @return {@code String} password, or {@code null} if it is not present.
     *
     */
    String getPassword();
    
    /**
     * Return password, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         specify the target password as part of the user credentials.
     *     </code>
     * </pre>
     *
     * @return {@code String} password, guaranteed to be non-null.
     * @throws NoSuchElementException if password is not present
     *
     */
    default @NonNull String requirePassword() {
        return CodeHelpers.require(getPassword(), "password");
    }

}

