package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Model describing connection parameters of gNMI node and augments of 
 * network-topology. Copyright (c) 2021 PANTHEON.tech s.r.o. All Rights Reserved. 
 * This program and the accompanying materials are made available under the terms 
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at https://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * module gnmi-topology {
 *   namespace urn:lighty:gnmi:topology;
 *   prefix gnmi;
 *   revision 2021-03-16 {
 *   }
 *   import network-topology {
 *     prefix nt;
 *     revision-date 2013-10-21;
 *   }
 *   import yang-ext {
 *     prefix ext;
 *     revision-date 2013-07-09;
 *   }
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   grouping credentials {
 *     container credentials {
 *       leaf username {
 *         type string;
 *       }
 *       leaf password {
 *         type string;
 *       }
 *     }
 *   }
 *   grouping security {
 *     uses credentials;
 *     choice security-choice {
 *       case secure {
 *         leaf keystore-id {
 *           type string;
 *         }
 *       }
 *       case insecure-debug-only {
 *         leaf connection-type {
 *           type enumeration {
 *             enum PLAINTEXT;
 *             enum INSECURE;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   grouping gnmi-connection-parameters {
 *     container connection-parameters {
 *       leaf host {
 *         type inet:host;
 *       }
 *       leaf port {
 *         type inet:port-number;
 *       }
 *       uses security;
 *     }
 *     container extensions-parameters {
 *       container gnmi-parameters {
 *         leaf overwrite-data-type {
 *           type enumeration {
 *             enum ALL;
 *             enum CONFIG;
 *             enum STATE;
 *             enum OPERATIONAL;
 *             enum UNRECOGNIZED;
 *             enum NONE;
 *           }
 *         }
 *         leaf use-model-name-prefix {
 *           type boolean;
 *           default false;
 *         }
 *         leaf path-target {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 *   grouping gnmi-node-state {
 *     container node-state {
 *       leaf node-status {
 *         config false;
 *         type enumeration {
 *           enum READY;
 *           enum CONNECTING;
 *           enum TRANSIENT_FAILURE;
 *           enum IDLE;
 *           enum SHUTDOWN;
 *           enum FAILURE;
 *         }
 *       }
 *       leaf failure-details {
 *         when "../node-status='FAILURE'";
 *         config false;
 *         type string;
 *       }
 *       container available-capabilities {
 *         config false;
 *         list available-capability {
 *           leaf capability {
 *             type string;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:topology-types {
 *     ext:augment-identifier gnmi-topology-types;
 *     container gnmi-topology {
 *       presence "The presence of the container node indicates presence of gNMI devices";
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:node {
 *     when ../../nt:topology-types/gnmi-topology;
 *     ext:augment-identifier gnmi-node;
 *     uses gnmi-connection-parameters;
 *     uses gnmi-node-state;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface GnmiTopologyData
    extends
    DataRoot
{





}

