package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * augment /nt:network-topology/nt:topology/nt:node {
 *   when ../../nt:topology-types/gnmi-topology;
 *   ext:augment-identifier gnmi-node;
 *   uses gnmi-connection-parameters;
 *   uses gnmi-node-state;
 * }
 * </pre>
 *
 * @see Node
 *
 */
@Generated("mdsal-binding-generator")
public interface GnmiNode
    extends
    Augmentation<Node>,
    GnmiConnectionParameters,
    GnmiNodeState
{




    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNode> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNode.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.@NonNull GnmiNode obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConnectionParameters());
        result = prime * result + Objects.hashCode(obj.getExtensionsParameters());
        result = prime * result + Objects.hashCode(obj.getNodeState());
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.@NonNull GnmiNode thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNode other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNode.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnectionParameters(), other.getConnectionParameters())) {
            return false;
        }
        if (!Objects.equals(thisObj.getExtensionsParameters(), other.getExtensionsParameters())) {
            return false;
        }
        if (!Objects.equals(thisObj.getNodeState(), other.getNodeState())) {
            return false;
        }
        return true;
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.@NonNull GnmiNode obj) {
        final var helper = MoreObjects.toStringHelper("GnmiNode");
        CodeHelpers.appendValue(helper, "connectionParameters", obj.getConnectionParameters());
        CodeHelpers.appendValue(helper, "extensionsParameters", obj.getExtensionsParameters());
        CodeHelpers.appendValue(helper, "nodeState", obj.getNodeState());
        return helper.toString();
    }

}

