package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.NodeState;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GnmiNode} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GnmiNode createGnmiNode(int fooXyzzy, int barBaz) {
 *         return new GnmiNodeBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GnmiNode, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GnmiNode
 *
 */
@Generated("mdsal-binding-generator")
public class GnmiNodeBuilder {

    private ConnectionParameters _connectionParameters;
    private ExtensionsParameters _extensionsParameters;
    private NodeState _nodeState;



    /**
     * Construct an empty builder.
     */
    public GnmiNodeBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link GnmiConnectionParameters}.
     *
     * @param arg GnmiConnectionParameters from which the builder should be initialized
     */
    public GnmiNodeBuilder(GnmiConnectionParameters arg) {
        this._connectionParameters = arg.getConnectionParameters();
        this._extensionsParameters = arg.getExtensionsParameters();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link GnmiNodeState}.
     *
     * @param arg GnmiNodeState from which the builder should be initialized
     */
    public GnmiNodeBuilder(GnmiNodeState arg) {
        this._nodeState = arg.getNodeState();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link GnmiNode}.
     *
     * @param base GnmiNode from which the builder should be initialized
     */
    public GnmiNodeBuilder(GnmiNode base) {
        this._connectionParameters = base.getConnectionParameters();
        this._extensionsParameters = base.getExtensionsParameters();
        this._nodeState = base.getNodeState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link GnmiNodeState}</li>
     *   <li>{@link GnmiConnectionParameters}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GnmiNodeState) {
            this._nodeState = ((GnmiNodeState)arg).getNodeState();
            isValidArg = true;
        }
        if (arg instanceof GnmiConnectionParameters) {
            this._connectionParameters = ((GnmiConnectionParameters)arg).getConnectionParameters();
            this._extensionsParameters = ((GnmiConnectionParameters)arg).getExtensionsParameters();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[GnmiNodeState, GnmiConnectionParameters]");
    }

    /**
     * Return current value associated with the property corresponding to {@link GnmiNode#getConnectionParameters()}.
     *
     * @return current value
     */
    public ConnectionParameters getConnectionParameters() {
        return _connectionParameters;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link GnmiNode#getExtensionsParameters()}.
     *
     * @return current value
     */
    public ExtensionsParameters getExtensionsParameters() {
        return _extensionsParameters;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link GnmiNode#getNodeState()}.
     *
     * @return current value
     */
    public NodeState getNodeState() {
        return _nodeState;
    }

    
    /**
     * Set the property corresponding to {@link GnmiNode#getConnectionParameters()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GnmiNodeBuilder setConnectionParameters(final ConnectionParameters value) {
        this._connectionParameters = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link GnmiNode#getExtensionsParameters()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GnmiNodeBuilder setExtensionsParameters(final ExtensionsParameters value) {
        this._extensionsParameters = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link GnmiNode#getNodeState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GnmiNodeBuilder setNodeState(final NodeState value) {
        this._nodeState = value;
        return this;
    }
    

    /**
     * A new {@link GnmiNode} instance.
     *
     * @return A new {@link GnmiNode} instance.
     */
    public @NonNull GnmiNode build() {
        return new GnmiNodeImpl(this);
    }

    private static final class GnmiNodeImpl
        implements GnmiNode {
    
        private final ConnectionParameters _connectionParameters;
        private final ExtensionsParameters _extensionsParameters;
        private final NodeState _nodeState;
    
        GnmiNodeImpl(GnmiNodeBuilder base) {
            this._connectionParameters = base.getConnectionParameters();
            this._extensionsParameters = base.getExtensionsParameters();
            this._nodeState = base.getNodeState();
        }
    
        @Override
        public ConnectionParameters getConnectionParameters() {
            return _connectionParameters;
        }
        
        @Override
        public ExtensionsParameters getExtensionsParameters() {
            return _extensionsParameters;
        }
        
        @Override
        public NodeState getNodeState() {
            return _nodeState;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GnmiNode.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GnmiNode.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GnmiNode.bindingToString(this);
        }
    }
}
